/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.observation;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.observation.DefaultMeterObservationHandler;
import io.micrometer.core.instrument.observation.MeterObservationHandler;
import io.micrometer.observation.GlobalObservationConvention;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationFilter;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationPredicate;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.handler.TracingAwareMeterObservationHandler;
import io.micrometer.tracing.handler.TracingObservationHandler;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationHandlerGrouping;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationProperties;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationRegistryCustomizer;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationRegistryPostProcessor;
import org.springframework.boot.actuate.autoconfigure.tracing.MicrometerTracingAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration(after={CompositeMeterRegistryAutoConfiguration.class, MicrometerTracingAutoConfiguration.class})
@ConditionalOnClass(value={ObservationRegistry.class})
@EnableConfigurationProperties(value={ObservationProperties.class})
public class ObservationAutoConfiguration {
    @Bean
    static ObservationRegistryPostProcessor observationRegistryPostProcessor(ObjectProvider<ObservationRegistryCustomizer<?>> observationRegistryCustomizers, ObjectProvider<ObservationPredicate> observationPredicates, ObjectProvider<GlobalObservationConvention<?>> observationConventions, ObjectProvider<ObservationHandler<?>> observationHandlers, ObjectProvider<ObservationHandlerGrouping> observationHandlerGrouping, ObjectProvider<ObservationFilter> observationFilters) {
        return new ObservationRegistryPostProcessor(observationRegistryCustomizers, observationPredicates, observationConventions, observationHandlers, observationHandlerGrouping, observationFilters);
    }

    @Bean
    @ConditionalOnMissingBean
    ObservationRegistry observationRegistry() {
        return ObservationRegistry.create();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={MeterRegistry.class})
    @ConditionalOnMissingBean(value={MeterObservationHandler.class})
    static class MeterObservationHandlerConfiguration {
        MeterObservationHandlerConfiguration() {
        }

        @ConditionalOnBean(value={Tracer.class})
        @Configuration(proxyBeanMethods=false)
        static class TracingAndMetricsObservationHandlerConfiguration {
            TracingAndMetricsObservationHandlerConfiguration() {
            }

            @Bean
            TracingAwareMeterObservationHandler<Observation.Context> tracingAwareMeterObservationHandler(MeterRegistry meterRegistry, Tracer tracer) {
                DefaultMeterObservationHandler delegate = new DefaultMeterObservationHandler(meterRegistry);
                return new TracingAwareMeterObservationHandler((MeterObservationHandler)delegate, tracer);
            }
        }

        @ConditionalOnMissingBean(type={"io.micrometer.tracing.Tracer"})
        @Configuration(proxyBeanMethods=false)
        static class OnlyMetricsMeterObservationHandlerConfiguration {
            OnlyMetricsMeterObservationHandlerConfiguration() {
            }

            @Bean
            DefaultMeterObservationHandler defaultMeterObservationHandler(MeterRegistry meterRegistry) {
                return new DefaultMeterObservationHandler(meterRegistry);
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={MeterRegistry.class, Tracer.class})
    static class MetricsWithTracingConfiguration {
        MetricsWithTracingConfiguration() {
        }

        @Bean
        ObservationHandlerGrouping metricsAndTracingObservationHandlerGrouping() {
            return new ObservationHandlerGrouping(List.of(TracingObservationHandler.class, MeterObservationHandler.class));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Tracer.class})
    @ConditionalOnMissingClass(value={"io.micrometer.core.instrument.MeterRegistry"})
    static class OnlyTracingConfiguration {
        OnlyTracingConfiguration() {
        }

        @Bean
        ObservationHandlerGrouping tracingObservationHandlerGrouping() {
            return new ObservationHandlerGrouping(TracingObservationHandler.class);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={MeterRegistry.class})
    @ConditionalOnMissingClass(value={"io.micrometer.tracing.Tracer"})
    static class OnlyMetricsConfiguration {
        OnlyMetricsConfiguration() {
        }

        @Bean
        ObservationHandlerGrouping metricsObservationHandlerGrouping() {
            return new ObservationHandlerGrouping(MeterObservationHandler.class);
        }
    }
}

