/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.partition;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.partition.support.Partitioner;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.StepLocator;
import org.springframework.batch.core.step.builder.FlowStepBuilder;
import org.springframework.batch.core.step.builder.JobStepBuilder;
import org.springframework.batch.core.step.builder.PartitionStepBuilder;
import org.springframework.batch.core.step.builder.SimpleStepBuilder;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.builder.TaskletStepBuilder;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.integration.partition.BeanFactoryStepLocator;
import org.springframework.batch.integration.partition.StepExecutionRequestHandler;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.integration.channel.NullChannel;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.dsl.StandardIntegrationFlow;
import org.springframework.integration.dsl.context.IntegrationFlowContext;
import org.springframework.messaging.MessageChannel;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;

public class RemotePartitioningWorkerStepBuilder
extends StepBuilder {
    private static final String SERVICE_ACTIVATOR_METHOD_NAME = "handle";
    private static final Log logger = LogFactory.getLog(RemotePartitioningWorkerStepBuilder.class);
    private MessageChannel inputChannel;
    private MessageChannel outputChannel;
    private JobExplorer jobExplorer;
    private StepLocator stepLocator;
    private BeanFactory beanFactory;

    public RemotePartitioningWorkerStepBuilder(String name) {
        super(name);
    }

    public RemotePartitioningWorkerStepBuilder inputChannel(MessageChannel inputChannel) {
        Assert.notNull((Object)inputChannel, (String)"inputChannel must not be null");
        this.inputChannel = inputChannel;
        return this;
    }

    public RemotePartitioningWorkerStepBuilder outputChannel(MessageChannel outputChannel) {
        Assert.notNull((Object)outputChannel, (String)"outputChannel must not be null");
        this.outputChannel = outputChannel;
        return this;
    }

    public RemotePartitioningWorkerStepBuilder jobExplorer(JobExplorer jobExplorer) {
        Assert.notNull((Object)jobExplorer, (String)"jobExplorer must not be null");
        this.jobExplorer = jobExplorer;
        return this;
    }

    public RemotePartitioningWorkerStepBuilder stepLocator(StepLocator stepLocator) {
        Assert.notNull((Object)stepLocator, (String)"stepLocator must not be null");
        this.stepLocator = stepLocator;
        return this;
    }

    public RemotePartitioningWorkerStepBuilder beanFactory(BeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"beanFactory must not be null");
        this.beanFactory = beanFactory;
        return this;
    }

    public RemotePartitioningWorkerStepBuilder repository(JobRepository jobRepository) {
        super.repository(jobRepository);
        return this;
    }

    public RemotePartitioningWorkerStepBuilder transactionManager(PlatformTransactionManager transactionManager) {
        super.transactionManager(transactionManager);
        return this;
    }

    public RemotePartitioningWorkerStepBuilder startLimit(int startLimit) {
        super.startLimit(startLimit);
        return this;
    }

    public RemotePartitioningWorkerStepBuilder listener(Object listener) {
        super.listener(listener);
        return this;
    }

    public RemotePartitioningWorkerStepBuilder listener(StepExecutionListener listener) {
        super.listener(listener);
        return this;
    }

    public RemotePartitioningWorkerStepBuilder allowStartIfComplete(boolean allowStartIfComplete) {
        super.allowStartIfComplete(allowStartIfComplete);
        return this;
    }

    public TaskletStepBuilder tasklet(Tasklet tasklet) {
        this.configureWorkerIntegrationFlow();
        return super.tasklet(tasklet);
    }

    public <I, O> SimpleStepBuilder<I, O> chunk(int chunkSize) {
        this.configureWorkerIntegrationFlow();
        return super.chunk(chunkSize);
    }

    public <I, O> SimpleStepBuilder<I, O> chunk(CompletionPolicy completionPolicy) {
        this.configureWorkerIntegrationFlow();
        return super.chunk(completionPolicy);
    }

    public PartitionStepBuilder partitioner(String stepName, Partitioner partitioner) {
        this.configureWorkerIntegrationFlow();
        return super.partitioner(stepName, partitioner);
    }

    public PartitionStepBuilder partitioner(Step step) {
        this.configureWorkerIntegrationFlow();
        return super.partitioner(step);
    }

    public JobStepBuilder job(Job job) {
        this.configureWorkerIntegrationFlow();
        return super.job(job);
    }

    public FlowStepBuilder flow(Flow flow) {
        this.configureWorkerIntegrationFlow();
        return super.flow(flow);
    }

    private void configureWorkerIntegrationFlow() {
        Assert.notNull((Object)this.inputChannel, (String)"An InputChannel must be provided");
        Assert.notNull((Object)this.jobExplorer, (String)"A JobExplorer must be provided");
        if (this.stepLocator == null) {
            BeanFactoryStepLocator beanFactoryStepLocator = new BeanFactoryStepLocator();
            beanFactoryStepLocator.setBeanFactory(this.beanFactory);
            this.stepLocator = beanFactoryStepLocator;
        }
        if (this.outputChannel == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"The output channel is set to a NullChannel. The master step must poll the job repository for workers status.");
            }
            this.outputChannel = new NullChannel();
        }
        StepExecutionRequestHandler stepExecutionRequestHandler = new StepExecutionRequestHandler();
        stepExecutionRequestHandler.setJobExplorer(this.jobExplorer);
        stepExecutionRequestHandler.setStepLocator(this.stepLocator);
        StandardIntegrationFlow standardIntegrationFlow = ((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlows.from((MessageChannel)this.inputChannel).handle((Object)stepExecutionRequestHandler, SERVICE_ACTIVATOR_METHOD_NAME)).channel(this.outputChannel)).get();
        IntegrationFlowContext integrationFlowContext = (IntegrationFlowContext)this.beanFactory.getBean(IntegrationFlowContext.class);
        integrationFlowContext.registration((IntegrationFlow)standardIntegrationFlow).autoStartup(false).register();
    }
}

