/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.partition;

import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.partition.PartitionHandler;
import org.springframework.batch.core.partition.StepExecutionSplitter;
import org.springframework.batch.core.partition.support.Partitioner;
import org.springframework.batch.core.partition.support.StepExecutionAggregator;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.PartitionStepBuilder;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.builder.StepBuilderHelper;
import org.springframework.batch.integration.partition.MessageChannelPartitionHandler;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.integration.channel.QueueChannel;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.dsl.StandardIntegrationFlow;
import org.springframework.integration.dsl.context.IntegrationFlowContext;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.PollableChannel;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;

@Deprecated
public class RemotePartitioningMasterStepBuilder
extends PartitionStepBuilder {
    private static final long DEFAULT_POLL_INTERVAL = 10000L;
    private static final long DEFAULT_TIMEOUT = -1L;
    private MessagingTemplate messagingTemplate;
    private MessageChannel inputChannel;
    private MessageChannel outputChannel;
    private JobExplorer jobExplorer;
    private BeanFactory beanFactory;
    private long pollInterval = 10000L;
    private long timeout = -1L;

    public RemotePartitioningMasterStepBuilder(String stepName) {
        super((StepBuilderHelper)new StepBuilder(stepName));
    }

    public RemotePartitioningMasterStepBuilder inputChannel(MessageChannel inputChannel) {
        Assert.notNull((Object)inputChannel, (String)"inputChannel must not be null");
        this.inputChannel = inputChannel;
        return this;
    }

    public RemotePartitioningMasterStepBuilder outputChannel(MessageChannel outputChannel) {
        Assert.notNull((Object)outputChannel, (String)"outputChannel must not be null");
        this.outputChannel = outputChannel;
        return this;
    }

    public RemotePartitioningMasterStepBuilder messagingTemplate(MessagingTemplate messagingTemplate) {
        Assert.notNull((Object)messagingTemplate, (String)"messagingTemplate must not be null");
        this.messagingTemplate = messagingTemplate;
        return this;
    }

    public RemotePartitioningMasterStepBuilder jobExplorer(JobExplorer jobExplorer) {
        Assert.notNull((Object)jobExplorer, (String)"jobExplorer must not be null");
        this.jobExplorer = jobExplorer;
        return this;
    }

    public RemotePartitioningMasterStepBuilder pollInterval(long pollInterval) {
        Assert.isTrue((pollInterval > 0L ? 1 : 0) != 0, (String)"The poll interval must be greater than zero");
        this.pollInterval = pollInterval;
        return this;
    }

    public RemotePartitioningMasterStepBuilder timeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public RemotePartitioningMasterStepBuilder beanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        return this;
    }

    public Step build() {
        Assert.state((this.outputChannel == null || this.messagingTemplate == null ? 1 : 0) != 0, (String)"You must specify either an outputChannel or a messagingTemplate but not both.");
        if (this.messagingTemplate == null) {
            this.messagingTemplate = new MessagingTemplate();
            this.messagingTemplate.setDefaultChannel(this.outputChannel);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"No messagingTemplate was provided, using a default one");
            }
        }
        MessageChannelPartitionHandler partitionHandler = new MessageChannelPartitionHandler();
        partitionHandler.setStepName(this.getStepName());
        partitionHandler.setGridSize(this.getGridSize());
        partitionHandler.setMessagingOperations(this.messagingTemplate);
        if (this.isPolling()) {
            partitionHandler.setJobExplorer(this.jobExplorer);
            partitionHandler.setPollInterval(this.pollInterval);
            partitionHandler.setTimeout(this.timeout);
        } else {
            QueueChannel replies = new QueueChannel();
            partitionHandler.setReplyChannel((PollableChannel)replies);
            StandardIntegrationFlow standardIntegrationFlow = ((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlows.from((MessageChannel)this.inputChannel).aggregate(aggregatorSpec -> aggregatorSpec.processor((Object)partitionHandler))).channel((MessageChannel)replies)).get();
            IntegrationFlowContext integrationFlowContext = (IntegrationFlowContext)this.beanFactory.getBean(IntegrationFlowContext.class);
            integrationFlowContext.registration((IntegrationFlow)standardIntegrationFlow).autoStartup(false).register();
        }
        try {
            partitionHandler.afterPropertiesSet();
            super.partitionHandler((PartitionHandler)partitionHandler);
        }
        catch (Exception e) {
            throw new BeanCreationException("Unable to create a master step for remote partitioning", (Throwable)e);
        }
        return super.build();
    }

    private boolean isPolling() {
        return this.inputChannel == null;
    }

    public RemotePartitioningMasterStepBuilder repository(JobRepository jobRepository) {
        super.repository(jobRepository);
        return this;
    }

    public RemotePartitioningMasterStepBuilder transactionManager(PlatformTransactionManager transactionManager) {
        super.transactionManager(transactionManager);
        return this;
    }

    public RemotePartitioningMasterStepBuilder partitioner(String slaveStepName, Partitioner partitioner) {
        super.partitioner(slaveStepName, partitioner);
        return this;
    }

    public RemotePartitioningMasterStepBuilder gridSize(int gridSize) {
        super.gridSize(gridSize);
        return this;
    }

    public RemotePartitioningMasterStepBuilder step(Step step) {
        super.step(step);
        return this;
    }

    public RemotePartitioningMasterStepBuilder splitter(StepExecutionSplitter splitter) {
        super.splitter(splitter);
        return this;
    }

    public RemotePartitioningMasterStepBuilder aggregator(StepExecutionAggregator aggregator) {
        super.aggregator(aggregator);
        return this;
    }

    public RemotePartitioningMasterStepBuilder startLimit(int startLimit) {
        super.startLimit(startLimit);
        return this;
    }

    public RemotePartitioningMasterStepBuilder listener(Object listener) {
        super.listener(listener);
        return this;
    }

    public RemotePartitioningMasterStepBuilder listener(StepExecutionListener listener) {
        super.listener(listener);
        return this;
    }

    public RemotePartitioningMasterStepBuilder allowStartIfComplete(boolean allowStartIfComplete) {
        super.allowStartIfComplete(allowStartIfComplete);
        return this;
    }

    public RemotePartitioningMasterStepBuilder partitionHandler(PartitionHandler partitionHandler) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("When configuring a master step for remote partitioning using the RemotePartitioningMasterStepBuilder, the partition handler will be automatically set to an instance of MessageChannelPartitionHandler. The partition handler must not be provided in this case.");
    }
}

