/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.kafka.builder;

import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.kafka.KafkaItemWriter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.util.Assert;

public class KafkaItemWriterBuilder<K, V> {
    private @Nullable KafkaTemplate<K, V> kafkaTemplate;
    private @Nullable Converter<V, K> itemKeyMapper;
    private boolean delete;
    private long timeout = -1L;

    public KafkaItemWriterBuilder<K, V> kafkaTemplate(KafkaTemplate<K, V> kafkaTemplate) {
        this.kafkaTemplate = kafkaTemplate;
        return this;
    }

    public KafkaItemWriterBuilder<K, V> itemKeyMapper(Converter<V, K> itemKeyMapper) {
        this.itemKeyMapper = itemKeyMapper;
        return this;
    }

    public KafkaItemWriterBuilder<K, V> delete(boolean delete) {
        this.delete = delete;
        return this;
    }

    public KafkaItemWriterBuilder<K, V> timeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public KafkaItemWriter<K, V> build() {
        Assert.notNull(this.kafkaTemplate, (String)"kafkaTemplate is required.");
        Assert.notNull(this.itemKeyMapper, (String)"itemKeyMapper is required.");
        KafkaItemWriter<K, V> writer = new KafkaItemWriter<K, V>(this.itemKeyMapper, this.kafkaTemplate);
        writer.setKafkaTemplate(this.kafkaTemplate);
        writer.setItemKeyMapper(this.itemKeyMapper);
        writer.setDelete(this.delete);
        writer.setTimeout(this.timeout);
        return writer;
    }
}

