/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.mail.javamail;

import jakarta.mail.internet.MimeMessage;
import java.util.Map;
import org.springframework.batch.infrastructure.item.Chunk;
import org.springframework.batch.infrastructure.item.ItemWriter;
import org.springframework.batch.infrastructure.item.mail.DefaultMailErrorHandler;
import org.springframework.batch.infrastructure.item.mail.MailErrorHandler;
import org.springframework.mail.MailException;
import org.springframework.mail.MailMessage;
import org.springframework.mail.MailSendException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMailMessage;
import org.springframework.util.Assert;

public class MimeMessageItemWriter
implements ItemWriter<MimeMessage> {
    private JavaMailSender mailSender;
    private MailErrorHandler mailErrorHandler = new DefaultMailErrorHandler();

    public MimeMessageItemWriter(JavaMailSender mailSender) {
        Assert.notNull((Object)mailSender, (String)"JavaMailSender must not be null");
        this.mailSender = mailSender;
    }

    public void setJavaMailSender(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    public void setMailErrorHandler(MailErrorHandler mailErrorHandler) {
        this.mailErrorHandler = mailErrorHandler;
    }

    @Override
    public void write(Chunk<? extends MimeMessage> chunk) throws MailException {
        try {
            this.mailSender.send(chunk.getItems().toArray(new MimeMessage[chunk.size()]));
        }
        catch (MailSendException e) {
            Map failedMessages = e.getFailedMessages();
            for (Map.Entry entry : failedMessages.entrySet()) {
                this.mailErrorHandler.handle((MailMessage)new MimeMailMessage((MimeMessage)entry.getKey()), (Exception)entry.getValue());
            }
        }
    }
}

