/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.database.builder;

import jakarta.persistence.EntityManagerFactory;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.database.JpaPagingItemReader;
import org.springframework.batch.infrastructure.item.database.orm.JpaQueryProvider;
import org.springframework.util.Assert;

public class JpaPagingItemReaderBuilder<T> {
    private int pageSize = 10;
    private @Nullable EntityManagerFactory entityManagerFactory;
    private @Nullable Map<String, Object> parameterValues;
    private @Nullable Map<String, Object> hintValues;
    private boolean transacted = true;
    private @Nullable String queryString;
    private @Nullable JpaQueryProvider queryProvider;
    private boolean saveState = true;
    private @Nullable String name;
    private int maxItemCount = Integer.MAX_VALUE;
    private int currentItemCount;

    public JpaPagingItemReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public JpaPagingItemReaderBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public JpaPagingItemReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public JpaPagingItemReaderBuilder<T> currentItemCount(int currentItemCount) {
        this.currentItemCount = currentItemCount;
        return this;
    }

    public JpaPagingItemReaderBuilder<T> pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public JpaPagingItemReaderBuilder<T> parameterValues(Map<String, Object> parameterValues) {
        this.parameterValues = parameterValues;
        return this;
    }

    public JpaPagingItemReaderBuilder<T> hintValues(Map<String, Object> hintValues) {
        this.hintValues = hintValues;
        return this;
    }

    public JpaPagingItemReaderBuilder<T> queryProvider(JpaQueryProvider queryProvider) {
        this.queryProvider = queryProvider;
        return this;
    }

    public JpaPagingItemReaderBuilder<T> queryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    public JpaPagingItemReaderBuilder<T> transacted(boolean transacted) {
        this.transacted = transacted;
        return this;
    }

    public JpaPagingItemReaderBuilder<T> entityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
        return this;
    }

    public JpaPagingItemReader<T> build() {
        Assert.isTrue((this.pageSize > 0 ? 1 : 0) != 0, (String)"pageSize must be greater than zero");
        Assert.notNull((Object)this.entityManagerFactory, (String)"An EntityManagerFactory is required");
        if (this.saveState) {
            Assert.hasText((String)this.name, (String)"A name is required when saveState is set to true");
        }
        if (this.queryProvider == null) {
            Assert.hasLength((String)this.queryString, (String)"Query string is required when queryProvider is null");
        }
        JpaPagingItemReader reader = new JpaPagingItemReader(this.entityManagerFactory);
        if (this.queryString != null) {
            reader.setQueryString(this.queryString);
        }
        if (this.parameterValues != null) {
            reader.setParameterValues(this.parameterValues);
        }
        if (this.hintValues != null) {
            reader.setHintValues(this.hintValues);
        }
        if (this.name != null) {
            reader.setName(this.name);
        }
        reader.setPageSize(this.pageSize);
        if (this.queryProvider != null) {
            reader.setQueryProvider(this.queryProvider);
        }
        reader.setTransacted(this.transacted);
        reader.setCurrentItemCount(this.currentItemCount);
        reader.setMaxItemCount(this.maxItemCount);
        reader.setSaveState(this.saveState);
        return reader;
    }
}

