/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.core;

import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitMessageOperations;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.MessagingMessageConverter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.core.AbstractMessagingTemplate;
import org.springframework.messaging.core.MessagePostProcessor;
import org.springframework.util.Assert;

public class RabbitMessagingTemplate
extends AbstractMessagingTemplate<String>
implements RabbitMessageOperations,
InitializingBean {
    private RabbitTemplate rabbitTemplate;
    private MessageConverter amqpMessageConverter = new MessagingMessageConverter();
    private boolean converterSet;
    private boolean useTemplateDefaultReceiveQueue;

    public RabbitMessagingTemplate() {
    }

    public RabbitMessagingTemplate(RabbitTemplate rabbitTemplate) {
        Assert.notNull((Object)rabbitTemplate, (String)"'rabbitTemplate' must not be null");
        this.rabbitTemplate = rabbitTemplate;
    }

    public void setRabbitTemplate(RabbitTemplate rabbitTemplate) {
        Assert.notNull((Object)rabbitTemplate, (String)"'rabbitTemplate' must not be null");
        this.rabbitTemplate = rabbitTemplate;
    }

    public RabbitTemplate getRabbitTemplate() {
        return this.rabbitTemplate;
    }

    public void setAmqpMessageConverter(MessageConverter amqpMessageConverter) {
        this.amqpMessageConverter = amqpMessageConverter;
        this.converterSet = true;
    }

    public MessageConverter getAmqpMessageConverter() {
        return this.amqpMessageConverter;
    }

    public void setUseTemplateDefaultReceiveQueue(boolean useTemplateDefaultReceiveQueue) {
        this.useTemplateDefaultReceiveQueue = useTemplateDefaultReceiveQueue;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.getRabbitTemplate(), (String)"Property 'rabbitTemplate' is required");
        Assert.notNull((Object)this.getAmqpMessageConverter(), (String)"Property 'amqpMessageConverter' is required");
        if (!this.converterSet) {
            ((MessagingMessageConverter)this.amqpMessageConverter).setPayloadConverter(this.rabbitTemplate.getMessageConverter());
        }
    }

    @Override
    public void send(@Nullable String exchange, @Nullable String routingKey, Message<?> message) throws MessagingException {
        this.doSend(exchange, routingKey, message);
    }

    @Override
    public void convertAndSend(@Nullable String exchange, @Nullable String routingKey, Object payload, @Nullable Map<String, Object> headers, @Nullable MessagePostProcessor postProcessor) throws MessagingException {
        Message message = this.doConvert(payload, headers, postProcessor);
        this.send(exchange, routingKey, message);
    }

    @Override
    public @Nullable Message<?> sendAndReceive(@Nullable String exchange, @Nullable String routingKey, Message<?> requestMessage) throws MessagingException {
        return this.doSendAndReceive(exchange, routingKey, requestMessage);
    }

    @Override
    public <T> @Nullable T convertSendAndReceive(@Nullable String exchange, @Nullable String routingKey, Object request, @Nullable Map<String, Object> headers, Class<T> targetClass, @Nullable MessagePostProcessor requestPostProcessor) throws MessagingException {
        Message requestMessage = this.doConvert(request, headers, requestPostProcessor);
        Message<?> replyMessage = this.sendAndReceive(exchange, routingKey, requestMessage);
        return (T)(replyMessage != null ? this.getMessageConverter().fromMessage(replyMessage, targetClass) : null);
    }

    protected void doSend(@Nullable String destination, Message<?> message) {
        try {
            Object correlation = message.getHeaders().get((Object)"amqp_publishConfirmCorrelation");
            if (correlation instanceof CorrelationData) {
                CorrelationData corrData = (CorrelationData)correlation;
                this.rabbitTemplate.send(destination, this.createMessage(message), corrData);
            } else {
                this.rabbitTemplate.send(destination, this.createMessage(message));
            }
        }
        catch (RuntimeException ex) {
            throw this.convertAmqpException(ex);
        }
    }

    protected void doSend(@Nullable String exchange, @Nullable String routingKey, Message<?> message) {
        try {
            Object correlation = message.getHeaders().get((Object)"amqp_publishConfirmCorrelation");
            if (correlation instanceof CorrelationData) {
                CorrelationData corrData = (CorrelationData)correlation;
                this.rabbitTemplate.send(exchange, routingKey, this.createMessage(message), corrData);
            } else {
                this.rabbitTemplate.send(exchange, routingKey, this.createMessage(message));
            }
        }
        catch (RuntimeException ex) {
            throw this.convertAmqpException(ex);
        }
    }

    public @Nullable Message<?> receive() {
        return this.doReceive(this.resolveDestination());
    }

    public <T> @Nullable T receiveAndConvert(Class<T> targetClass) {
        return (T)this.receiveAndConvert(this.resolveDestination(), targetClass);
    }

    private String resolveDestination() {
        String dest = null;
        if (this.useTemplateDefaultReceiveQueue) {
            dest = this.rabbitTemplate.getDefaultReceiveQueue();
        }
        if (dest == null) {
            dest = (String)this.getRequiredDefaultDestination();
        }
        return dest;
    }

    protected @Nullable Message<?> doReceive(String destination) {
        try {
            org.springframework.amqp.core.Message amqpMessage = this.rabbitTemplate.receive(destination);
            return this.convertAmqpMessage(amqpMessage);
        }
        catch (RuntimeException ex) {
            throw this.convertAmqpException(ex);
        }
    }

    protected @Nullable Message<?> doSendAndReceive(@Nullable String destination, Message<?> requestMessage) {
        try {
            org.springframework.amqp.core.Message amqpMessage = this.rabbitTemplate.sendAndReceive(destination, this.createMessage(requestMessage));
            return this.convertAmqpMessage(amqpMessage);
        }
        catch (RuntimeException ex) {
            throw this.convertAmqpException(ex);
        }
    }

    protected @Nullable Message<?> doSendAndReceive(@Nullable String exchange, @Nullable String routingKey, Message<?> requestMessage) {
        try {
            org.springframework.amqp.core.Message amqpMessage = this.rabbitTemplate.sendAndReceive(exchange, routingKey, this.createMessage(requestMessage));
            return this.convertAmqpMessage(amqpMessage);
        }
        catch (RuntimeException ex) {
            throw this.convertAmqpException(ex);
        }
    }

    private org.springframework.amqp.core.Message createMessage(Message<?> message) {
        try {
            return this.getAmqpMessageConverter().toMessage(message, new MessageProperties());
        }
        catch (org.springframework.amqp.support.converter.MessageConversionException ex) {
            throw new MessageConversionException("Could not convert '" + String.valueOf(message) + "'", (Throwable)ex);
        }
    }

    protected @Nullable Message<?> convertAmqpMessage(@Nullable org.springframework.amqp.core.Message message) {
        if (message == null) {
            return null;
        }
        try {
            return (Message)this.getAmqpMessageConverter().fromMessage(message);
        }
        catch (Exception ex) {
            throw new MessageConversionException("Could not convert '" + String.valueOf(message) + "'", (Throwable)ex);
        }
    }

    protected MessagingException convertAmqpException(RuntimeException ex) {
        if (ex instanceof MessagingException) {
            MessagingException mex = (MessagingException)ex;
            return mex;
        }
        if (ex instanceof org.springframework.amqp.support.converter.MessageConversionException) {
            return new MessageConversionException(ex.getMessage(), (Throwable)ex);
        }
        return new MessagingException(ex.getMessage(), (Throwable)ex);
    }
}

