/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import org.jspecify.annotations.Nullable;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionNameStrategy;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public class SimplePropertyValueConnectionNameStrategy
implements ConnectionNameStrategy,
EnvironmentAware {
    private final String propertyName;
    private @Nullable String propertyValue;
    private @Nullable Environment environment;

    public SimplePropertyValueConnectionNameStrategy(String propertyName) {
        Assert.notNull((Object)propertyName, (String)"'propertyName' cannot be null");
        this.propertyName = propertyName;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Override
    public String obtainNewConnectionName(ConnectionFactory connectionFactory) {
        if (this.propertyValue == null) {
            if (this.environment != null) {
                this.propertyValue = this.environment.getProperty(this.propertyName);
            }
            if (this.propertyValue == null) {
                this.propertyValue = this.propertyName;
            }
        }
        return this.propertyValue;
    }
}

