/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.config.AbstractRetryOperationsInterceptorFactoryBean;
import org.springframework.amqp.rabbit.config.StatelessRetryOperationsInterceptor;
import org.springframework.amqp.rabbit.retry.MessageBatchRecoverer;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;

public class StatelessRetryOperationsInterceptorFactoryBean
extends AbstractRetryOperationsInterceptorFactoryBean {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public StatelessRetryOperationsInterceptor getObject() {
        return new StatelessRetryOperationsInterceptor(this.getRetryPolicy(), this::recover);
    }

    protected @Nullable Object recover(@Nullable Object[] args, Throwable cause) {
        MessageRecoverer messageRecoverer = this.getMessageRecoverer();
        Object arg = args[1];
        if (messageRecoverer == null) {
            this.logger.warn((Object)("Message(s) dropped on recovery: " + String.valueOf(arg)), cause);
        } else if (arg instanceof Message) {
            Message message = (Message)arg;
            messageRecoverer.recover(message, cause);
        } else if (arg instanceof List && messageRecoverer instanceof MessageBatchRecoverer) {
            MessageBatchRecoverer messageBatchRecoverer = (MessageBatchRecoverer)messageRecoverer;
            messageBatchRecoverer.recover((List)arg, cause);
        }
        return null;
    }

    public Class<?> getObjectType() {
        return StatelessRetryOperationsInterceptor.class;
    }
}

