/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit;

import java.util.concurrent.ConcurrentMap;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.AmqpReplyTimeoutException;
import org.springframework.amqp.rabbit.RabbitFuture;
import org.springframework.amqp.rabbit.listener.DirectReplyToMessageListenerContainer;

public class TimeoutTask
implements Runnable {
    private final RabbitFuture<?> future;
    private final ConcurrentMap<String, RabbitFuture<?>> pending;
    private final @Nullable DirectReplyToMessageListenerContainer container;

    TimeoutTask(RabbitFuture<?> future, ConcurrentMap<String, RabbitFuture<?>> pending, @Nullable DirectReplyToMessageListenerContainer container) {
        this.future = future;
        this.pending = pending;
        this.container = container;
    }

    @Override
    public void run() {
        this.pending.remove(this.future.getCorrelationId());
        DirectReplyToMessageListenerContainer.ChannelHolder holder = this.future.getChannelHolder();
        if (holder != null && this.container != null) {
            this.container.releaseConsumerFor(holder, false, null);
        }
        this.future.completeExceptionally((Throwable)new AmqpReplyTimeoutException("Reply timed out", this.future.getRequestMessage()));
    }
}

