/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rabbit.stream.support;

import com.rabbitmq.stream.Environment;
import com.rabbitmq.stream.StreamCreator;
import java.util.function.Consumer;
import org.springframework.context.SmartLifecycle;
import org.springframework.util.Assert;

public class StreamAdmin
implements SmartLifecycle {
    private final StreamCreator streamCreator;
    private final Consumer<StreamCreator> callback;
    private boolean autoStartup = true;
    private int phase;
    private volatile boolean running;

    public StreamAdmin(Environment env, Consumer<StreamCreator> callback) {
        Assert.notNull((Object)env, (String)"Environment cannot be null");
        Assert.notNull(callback, (String)"'callback' cannot be null");
        this.streamCreator = env.streamCreator();
        this.callback = callback;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void start() {
        this.callback.accept(this.streamCreator);
        this.running = true;
    }

    public void stop() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }
}

