/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.rag.preretrieval.query.transformation;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.prompt.PromptTemplate;
import org.springframework.ai.rag.Query;
import org.springframework.ai.rag.preretrieval.query.transformation.QueryTransformer;
import org.springframework.ai.rag.util.PromptAssert;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class TranslationQueryTransformer
implements QueryTransformer {
    private static final Logger logger = LoggerFactory.getLogger(TranslationQueryTransformer.class);
    private static final PromptTemplate DEFAULT_PROMPT_TEMPLATE = new PromptTemplate("Given a user query, translate it to {targetLanguage}.\nIf the query is already in {targetLanguage}, return it unchanged.\nIf you don't know the language of the query, return it unchanged.\nDo not add explanations nor any other text.\n\nOriginal query: {query}\n\nTranslated query:\n");
    private final ChatClient chatClient;
    private final PromptTemplate promptTemplate;
    private final String targetLanguage;

    public TranslationQueryTransformer(ChatClient.Builder chatClientBuilder, @Nullable PromptTemplate promptTemplate, String targetLanguage) {
        Assert.notNull((Object)chatClientBuilder, (String)"chatClientBuilder cannot be null");
        Assert.hasText((String)targetLanguage, (String)"targetLanguage cannot be null or empty");
        this.chatClient = chatClientBuilder.build();
        this.promptTemplate = promptTemplate != null ? promptTemplate : DEFAULT_PROMPT_TEMPLATE;
        this.targetLanguage = targetLanguage;
        PromptAssert.templateHasRequiredPlaceholders(this.promptTemplate, "targetLanguage", "query");
    }

    @Override
    public Query transform(Query query) {
        Assert.notNull((Object)query, (String)"query cannot be null");
        logger.debug("Translating query to target language: {}", (Object)this.targetLanguage);
        String translatedQueryText = this.chatClient.prompt().user(user -> user.text(this.promptTemplate.getTemplate()).param("targetLanguage", (Object)this.targetLanguage).param("query", (Object)query.text())).call().content();
        if (!StringUtils.hasText((String)translatedQueryText)) {
            logger.warn("Query translation result is null/empty. Returning the input query unchanged.");
            return query;
        }
        return query.mutate().text(translatedQueryText).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ChatClient.Builder chatClientBuilder;
        @Nullable
        private PromptTemplate promptTemplate;
        private String targetLanguage;

        private Builder() {
        }

        public Builder chatClientBuilder(ChatClient.Builder chatClientBuilder) {
            this.chatClientBuilder = chatClientBuilder;
            return this;
        }

        public Builder promptTemplate(PromptTemplate promptTemplate) {
            this.promptTemplate = promptTemplate;
            return this;
        }

        public Builder targetLanguage(String targetLanguage) {
            this.targetLanguage = targetLanguage;
            return this;
        }

        public TranslationQueryTransformer build() {
            return new TranslationQueryTransformer(this.chatClientBuilder, this.promptTemplate, this.targetLanguage);
        }
    }
}

