/*
 * Copyright 2023-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.ai.model;

/**
 * Interface representing metadata associated with the results of an AI model. This
 * interface focuses on providing additional context and insights into the results
 * generated by AI models. It could include information like computation time, model
 * version, or other relevant details that enhance understanding and management of AI
 * model outputs in various applications.
 *
 * @author Mark Pollack
 * @since 0.8.0
 */
public interface ResultMetadata {

}
