/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp;

import io.modelcontextprotocol.spec.McpSchema;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.mcp.McpConnectionInfo;
import org.springframework.ai.mcp.McpToolNamePrefixGenerator;
import org.springframework.ai.mcp.McpToolUtils;

public class DefaultMcpToolNamePrefixGenerator
implements McpToolNamePrefixGenerator {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMcpToolNamePrefixGenerator.class);
    private Set<ConnectionId> existingConnections = ConcurrentHashMap.newKeySet();
    private Set<String> allUsedToolNames = ConcurrentHashMap.newKeySet();
    private AtomicInteger counter = new AtomicInteger(1);

    @Override
    public String prefixedToolName(McpConnectionInfo mcpConnectionInfo, McpSchema.Tool tool) {
        Object uniqueToolName = McpToolUtils.format(tool.name());
        if (this.existingConnections.add(new ConnectionId(mcpConnectionInfo.clientInfo(), mcpConnectionInfo.initializeResult() != null ? mcpConnectionInfo.initializeResult().serverInfo() : null, tool)) && !this.allUsedToolNames.add((String)uniqueToolName)) {
            uniqueToolName = "alt_" + this.counter.getAndIncrement() + "_" + (String)uniqueToolName;
            this.allUsedToolNames.add((String)uniqueToolName);
            logger.warn("Tool name '{}' already exists. Using unique tool name '{}'", (Object)tool.name(), uniqueToolName);
        }
        return uniqueToolName;
    }

    private record ConnectionId(McpSchema.Implementation clientInfo, McpSchema.Implementation serverInfo, McpSchema.Tool tool) {
    }
}

