/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client.advisor;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.springframework.ai.chat.client.ChatClientRequest;
import org.springframework.ai.chat.client.ChatClientResponse;
import org.springframework.ai.chat.client.advisor.api.Advisor;
import org.springframework.ai.chat.client.advisor.api.BaseAdvisorChain;
import org.springframework.ai.chat.client.advisor.api.CallAdvisor;
import org.springframework.ai.chat.client.advisor.api.StreamAdvisor;
import org.springframework.ai.chat.client.advisor.observation.AdvisorObservationContext;
import org.springframework.ai.chat.client.advisor.observation.AdvisorObservationConvention;
import org.springframework.ai.chat.client.advisor.observation.AdvisorObservationDocumentation;
import org.springframework.ai.chat.client.advisor.observation.DefaultAdvisorObservationConvention;
import org.springframework.core.OrderComparator;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;

public class DefaultAroundAdvisorChain
implements BaseAdvisorChain {
    public static final AdvisorObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultAdvisorObservationConvention();
    private final List<CallAdvisor> originalCallAdvisors;
    private final List<StreamAdvisor> originalStreamAdvisors;
    private final Deque<CallAdvisor> callAdvisors;
    private final Deque<StreamAdvisor> streamAdvisors;
    private final ObservationRegistry observationRegistry;

    DefaultAroundAdvisorChain(ObservationRegistry observationRegistry, Deque<CallAdvisor> callAdvisors, Deque<StreamAdvisor> streamAdvisors) {
        Assert.notNull((Object)observationRegistry, (String)"the observationRegistry must be non-null");
        Assert.notNull(callAdvisors, (String)"the callAdvisors must be non-null");
        Assert.notNull(streamAdvisors, (String)"the streamAdvisors must be non-null");
        this.observationRegistry = observationRegistry;
        this.callAdvisors = callAdvisors;
        this.streamAdvisors = streamAdvisors;
        this.originalCallAdvisors = List.copyOf(callAdvisors);
        this.originalStreamAdvisors = List.copyOf(streamAdvisors);
    }

    public static Builder builder(ObservationRegistry observationRegistry) {
        return new Builder(observationRegistry);
    }

    @Override
    public ChatClientResponse nextCall(ChatClientRequest chatClientRequest) {
        Assert.notNull((Object)chatClientRequest, (String)"the chatClientRequest cannot be null");
        if (this.callAdvisors.isEmpty()) {
            throw new IllegalStateException("No CallAdvisors available to execute");
        }
        CallAdvisor advisor = this.callAdvisors.pop();
        AdvisorObservationContext observationContext = AdvisorObservationContext.builder().advisorName(advisor.getName()).chatClientRequest(chatClientRequest).order(advisor.getOrder()).build();
        return (ChatClientResponse)AdvisorObservationDocumentation.AI_ADVISOR.observation(null, DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> advisor.adviseCall(chatClientRequest, this));
    }

    @Override
    public Flux<ChatClientResponse> nextStream(ChatClientRequest chatClientRequest) {
        Assert.notNull((Object)chatClientRequest, (String)"the chatClientRequest cannot be null");
        return Flux.deferContextual(contextView -> {
            if (this.streamAdvisors.isEmpty()) {
                return Flux.error((Throwable)new IllegalStateException("No StreamAdvisors available to execute"));
            }
            StreamAdvisor advisor = this.streamAdvisors.pop();
            AdvisorObservationContext observationContext = AdvisorObservationContext.builder().advisorName(advisor.getName()).chatClientRequest(chatClientRequest).order(advisor.getOrder()).build();
            Observation observation = AdvisorObservationDocumentation.AI_ADVISOR.observation(null, DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry);
            observation.parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
            return Flux.defer(() -> advisor.adviseStream(chatClientRequest, this).doOnError(arg_0 -> ((Observation)observation).error(arg_0)).doFinally(s -> observation.stop()).contextWrite(ctx -> ctx.put((Object)"micrometer.observation", (Object)observation)));
        });
    }

    @Override
    public List<CallAdvisor> getCallAdvisors() {
        return this.originalCallAdvisors;
    }

    @Override
    public List<StreamAdvisor> getStreamAdvisors() {
        return this.originalStreamAdvisors;
    }

    @Override
    public ObservationRegistry getObservationRegistry() {
        return this.observationRegistry;
    }

    public static class Builder {
        private final ObservationRegistry observationRegistry;
        private final Deque<CallAdvisor> callAdvisors;
        private final Deque<StreamAdvisor> streamAdvisors;

        public Builder(ObservationRegistry observationRegistry) {
            this.observationRegistry = observationRegistry;
            this.callAdvisors = new ConcurrentLinkedDeque<CallAdvisor>();
            this.streamAdvisors = new ConcurrentLinkedDeque<StreamAdvisor>();
        }

        public Builder push(Advisor advisor) {
            Assert.notNull((Object)advisor, (String)"the advisor must be non-null");
            return this.pushAll(List.of(advisor));
        }

        public Builder pushAll(List<? extends Advisor> advisors) {
            Assert.notNull(advisors, (String)"the advisors must be non-null");
            Assert.noNullElements(advisors, (String)"the advisors must not contain null elements");
            if (!CollectionUtils.isEmpty(advisors)) {
                List<StreamAdvisor> streamAroundAdvisorList;
                List<CallAdvisor> callAroundAdvisorList = advisors.stream().filter(a -> a instanceof CallAdvisor).map(a -> (CallAdvisor)a).toList();
                if (!CollectionUtils.isEmpty(callAroundAdvisorList)) {
                    callAroundAdvisorList.forEach(this.callAdvisors::push);
                }
                if (!CollectionUtils.isEmpty(streamAroundAdvisorList = advisors.stream().filter(a -> a instanceof StreamAdvisor).map(a -> (StreamAdvisor)a).toList())) {
                    streamAroundAdvisorList.forEach(this.streamAdvisors::push);
                }
                this.reOrder();
            }
            return this;
        }

        private void reOrder() {
            ArrayList<CallAdvisor> callAdvisors = new ArrayList<CallAdvisor>(this.callAdvisors);
            OrderComparator.sort(callAdvisors);
            this.callAdvisors.clear();
            callAdvisors.forEach(this.callAdvisors::addLast);
            ArrayList<StreamAdvisor> streamAdvisors = new ArrayList<StreamAdvisor>(this.streamAdvisors);
            OrderComparator.sort(streamAdvisors);
            this.streamAdvisors.clear();
            streamAdvisors.forEach(this.streamAdvisors::addLast);
        }

        public DefaultAroundAdvisorChain build() {
            return new DefaultAroundAdvisorChain(this.observationRegistry, this.callAdvisors, this.streamAdvisors);
        }
    }
}

