/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.server.common.autoconfigure.properties;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(value="spring.ai.mcp.server")
public class McpServerProperties {
    public static final String CONFIG_PREFIX = "spring.ai.mcp.server";
    private boolean enabled = true;
    private boolean stdio = false;
    private String name = "mcp-server";
    private String version = "1.0.0";
    private String instructions = null;
    private ApiType type = ApiType.SYNC;
    private Capabilities capabilities = new Capabilities();
    private ServerProtocol protocol = ServerProtocol.SSE;
    private Duration requestTimeout = Duration.ofSeconds(20L);
    private Map<String, String> toolResponseMimeType = new HashMap<String, String>();

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Duration requestTimeout) {
        Assert.notNull((Object)requestTimeout, (String)"Request timeout must not be null");
        this.requestTimeout = requestTimeout;
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    public boolean isStdio() {
        return this.stdio;
    }

    public void setStdio(boolean stdio) {
        this.stdio = stdio;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        Assert.hasText((String)name, (String)"Name must not be empty");
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        Assert.hasText((String)version, (String)"Version must not be empty");
        this.version = version;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public ApiType getType() {
        return this.type;
    }

    public void setType(ApiType serverType) {
        Assert.notNull((Object)((Object)serverType), (String)"Server type must not be null");
        this.type = serverType;
    }

    public Map<String, String> getToolResponseMimeType() {
        return this.toolResponseMimeType;
    }

    public ServerProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ServerProtocol serverMode) {
        Assert.notNull((Object)((Object)serverMode), (String)"Server mode must not be null");
        this.protocol = serverMode;
    }

    public static enum ApiType {
        SYNC,
        ASYNC;

    }

    public static class Capabilities {
        private boolean resource = true;
        private boolean tool = true;
        private boolean prompt = true;
        private boolean completion = true;

        public boolean isResource() {
            return this.resource;
        }

        public void setResource(boolean resource) {
            this.resource = resource;
        }

        public boolean isTool() {
            return this.tool;
        }

        public void setTool(boolean tool) {
            this.tool = tool;
        }

        public boolean isPrompt() {
            return this.prompt;
        }

        public void setPrompt(boolean prompt) {
            this.prompt = prompt;
        }

        public boolean isCompletion() {
            return this.completion;
        }

        public void setCompletion(boolean completion) {
            this.completion = completion;
        }
    }

    public static enum ServerProtocol {
        SSE,
        STREAMABLE,
        STATELESS;

    }
}

