/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.data;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.data.ControllerType;
import org.springdoc.core.data.DataRestRepository;
import org.springdoc.core.data.DataRestRequestService;
import org.springdoc.core.data.DataRestResponseService;
import org.springdoc.core.data.DataRestTagsService;
import org.springdoc.core.models.MethodAttributes;
import org.springdoc.core.service.OperationService;
import org.springdoc.core.utils.SpringDocAnnotationsUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.repository.query.Param;
import org.springframework.data.rest.core.mapping.MethodResourceMapping;
import org.springframework.data.rest.core.mapping.ParameterMetadata;
import org.springframework.data.rest.core.mapping.ParametersMetadata;
import org.springframework.data.rest.core.mapping.ResourceDescription;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.TypedResourceDescription;
import org.springframework.data.rest.webmvc.support.DefaultedPageable;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;

public class DataRestOperationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataRestOperationService.class);
    private static final String STRING_SEPARATOR = "-";
    private final DataRestRequestService dataRestRequestService;
    private final DataRestTagsService tagsBuilder;
    private final DataRestResponseService dataRestResponseService;
    private final OperationService operationService;

    public DataRestOperationService(DataRestRequestService dataRestRequestService, DataRestTagsService tagsBuilder, DataRestResponseService dataRestResponseService, OperationService operationService) {
        this.dataRestRequestService = dataRestRequestService;
        this.tagsBuilder = tagsBuilder;
        this.dataRestResponseService = dataRestResponseService;
        this.operationService = operationService;
    }

    public Operation buildOperation(HandlerMethod handlerMethod, DataRestRepository dataRestRepository, OpenAPI openAPI, RequestMethod requestMethod, String operationPath, MethodAttributes methodAttributes, ResourceMetadata resourceMetadata, MethodResourceMapping methodResourceMapping, ControllerType controllerType) {
        Operation operation = null;
        if (ControllerType.ENTITY.equals((Object)controllerType) || ControllerType.PROPERTY.equals((Object)controllerType) || ControllerType.SCHEMA.equals((Object)controllerType) || ControllerType.GENERAL.equals((Object)controllerType)) {
            operation = this.buildEntityOperation(handlerMethod, dataRestRepository, openAPI, requestMethod, operationPath, methodAttributes, resourceMetadata);
        } else if (ControllerType.SEARCH.equals((Object)controllerType)) {
            operation = this.buildSearchOperation(handlerMethod, dataRestRepository, openAPI, requestMethod, methodAttributes, methodResourceMapping, resourceMetadata);
        }
        return operation;
    }

    private Operation buildEntityOperation(HandlerMethod handlerMethod, DataRestRepository dataRestRepository, OpenAPI openAPI, RequestMethod requestMethod, String operationPath, MethodAttributes methodAttributes, ResourceMetadata resourceMetadata) {
        Class<?> domainType = null;
        if (!ControllerType.GENERAL.equals((Object)dataRestRepository.getControllerType())) {
            domainType = dataRestRepository.getDomainType();
        }
        Operation operation = this.initOperation(handlerMethod, domainType, requestMethod);
        this.dataRestRequestService.buildParameters(openAPI, handlerMethod, requestMethod, methodAttributes, operation, resourceMetadata, dataRestRepository);
        this.dataRestResponseService.buildEntityResponse(operation, handlerMethod, openAPI, requestMethod, operationPath, methodAttributes, dataRestRepository, resourceMetadata);
        this.tagsBuilder.buildEntityTags(operation, handlerMethod, dataRestRepository);
        if (domainType != null) {
            this.addOperationDescription(operation, requestMethod, domainType.getSimpleName().toLowerCase(), dataRestRepository);
        }
        return operation;
    }

    private Operation buildSearchOperation(HandlerMethod handlerMethod, DataRestRepository dataRestRepository, OpenAPI openAPI, RequestMethod requestMethod, MethodAttributes methodAttributes, MethodResourceMapping methodResourceMapping, ResourceMetadata resourceMetadata) {
        Class<?> domainType = dataRestRepository.getDomainType();
        Operation operation = this.initOperation(handlerMethod, domainType, requestMethod);
        io.swagger.v3.oas.annotations.Operation apiOperation = (io.swagger.v3.oas.annotations.Operation)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)methodResourceMapping.getMethod(), io.swagger.v3.oas.annotations.Operation.class);
        if (apiOperation != null) {
            this.operationService.parse(apiOperation, operation, openAPI, methodAttributes);
        }
        ParametersMetadata parameterMetadata = methodResourceMapping.getParametersMetadata();
        Method method = methodResourceMapping.getMethod();
        if (!CollectionUtils.isEmpty((Collection)parameterMetadata.getParameterNames())) {
            MethodParameter[] parameters;
            Iterator repositoryHandlerMethod = new HandlerMethod(methodResourceMapping.getMethod().getDeclaringClass(), methodResourceMapping.getMethod());
            for (MethodParameter methodParameter2 : parameters = repositoryHandlerMethod.getMethodParameters()) {
                this.dataRestRequestService.buildCommonParameters(openAPI, requestMethod, methodAttributes, operation, new String[]{methodParameter2.getParameterName()}, new MethodParameter[]{methodParameter2}, dataRestRepository);
            }
        }
        for (ParameterMetadata parameterMetadatum : parameterMetadata) {
            String pName = parameterMetadatum.getName();
            ResourceDescription description = parameterMetadatum.getDescription();
            if (!(description instanceof TypedResourceDescription)) continue;
            Type type = this.getParameterType(pName, method, description);
            Schema schema = SpringDocAnnotationsUtils.extractSchema(openAPI.getComponents(), type, null, null);
            io.swagger.v3.oas.models.parameters.Parameter parameter = this.getParameterFromAnnotations(openAPI, methodAttributes, method, pName);
            if (parameter == null) {
                parameter = new io.swagger.v3.oas.models.parameters.Parameter().name(pName).in(ParameterIn.QUERY.toString()).schema(schema);
            }
            operation.addParametersItem(parameter);
        }
        if (methodResourceMapping.isPagingResource()) {
            MethodParameter[] parameters = handlerMethod.getMethodParameters();
            Arrays.stream(parameters).filter(methodParameter -> DefaultedPageable.class.equals((Object)methodParameter.getParameterType())).findAny().ifPresent(methodParameterPage -> this.dataRestRequestService.buildCommonParameters(openAPI, requestMethod, methodAttributes, operation, new String[]{methodParameterPage.getParameterName()}, new MethodParameter[]{methodParameterPage}, dataRestRepository));
        }
        this.dataRestResponseService.buildSearchResponse(operation, handlerMethod, openAPI, methodResourceMapping, domainType, methodAttributes, resourceMetadata, dataRestRepository);
        this.tagsBuilder.buildSearchTags(operation, handlerMethod, dataRestRepository, method);
        return operation;
    }

    private Type getParameterType(String pName, Method method, ResourceDescription description) {
        Object type = null;
        java.lang.reflect.Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            java.lang.reflect.Parameter parameter = parameters[i];
            if (!pName.equals(parameter.getName()) && !pName.equals(parameter.getAnnotation(Param.class).value())) continue;
            ResolvableType resolvableType = ResolvableType.forMethodParameter((Method)method, (int)i);
            type = resolvableType.getType();
            break;
        }
        if (type == null) {
            TypedResourceDescription typedResourceDescription = (TypedResourceDescription)description;
            Field fieldType = FieldUtils.getField(TypedResourceDescription.class, (String)"type", (boolean)true);
            try {
                type = (Type)fieldType.get(typedResourceDescription);
            }
            catch (IllegalAccessException e) {
                LOGGER.warn(e.getMessage());
                type = String.class;
            }
        }
        return type;
    }

    private io.swagger.v3.oas.models.parameters.Parameter getParameterFromAnnotations(OpenAPI openAPI, MethodAttributes methodAttributes, Method method, String pName) {
        io.swagger.v3.oas.models.parameters.Parameter parameter = null;
        for (java.lang.reflect.Parameter reflectParameter : method.getParameters()) {
            Parameter parameterDoc;
            Param paramAnnotation = reflectParameter.getAnnotation(Param.class);
            if (paramAnnotation == null || !paramAnnotation.value().equals(pName) || (parameterDoc = (Parameter)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)AnnotatedElementUtils.forAnnotations((Annotation[])reflectParameter.getAnnotations()), Parameter.class)) == null || parameterDoc.hidden() && !parameterDoc.schema().hidden()) continue;
            parameter = this.dataRestRequestService.buildParameterFromDoc(parameterDoc, openAPI.getComponents(), methodAttributes.getJsonViewAnnotation(), methodAttributes.getLocale());
            parameter.setName(pName);
        }
        return parameter;
    }

    private Operation initOperation(HandlerMethod handlerMethod, Class<?> domainType, RequestMethod requestMethod) {
        Operation operation = new Operation();
        StringBuilder operationIdBuilder = new StringBuilder();
        operationIdBuilder.append(handlerMethod.getMethod().getName());
        if (domainType != null) {
            operationIdBuilder.append(STRING_SEPARATOR).append(domainType.getSimpleName().toLowerCase()).append(STRING_SEPARATOR).append(requestMethod.toString().toLowerCase());
        }
        operation.setOperationId(operationIdBuilder.toString());
        return operation;
    }

    private void addOperationDescription(Operation operation, RequestMethod requestMethod, String entity, DataRestRepository dataRestRepository) {
        switch (requestMethod) {
            case GET: {
                operation.setDescription(this.createDescription("get-", entity, dataRestRepository));
                break;
            }
            case POST: {
                operation.setDescription(this.createDescription("create-", entity, dataRestRepository));
                break;
            }
            case DELETE: {
                operation.setDescription(this.createDescription("delete-", entity, dataRestRepository));
                break;
            }
            case PUT: {
                operation.setDescription(this.createDescription("update-", entity, dataRestRepository));
                break;
            }
            case PATCH: {
                operation.setDescription(this.createDescription("patch-", entity, dataRestRepository));
                break;
            }
            default: {
                throw new IllegalArgumentException(requestMethod.name());
            }
        }
    }

    private String createDescription(String action, String entity, DataRestRepository dataRestRepository) {
        String description = ControllerType.PROPERTY.equals((Object)dataRestRepository.getControllerType()) ? action + dataRestRepository.getPropertyType().getSimpleName().toLowerCase() + "-by-" + entity + "-Id" : action + entity;
        return description;
    }
}

