/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.security;

import org.springdoc.core.SpringDocUtils;
import org.springdoc.security.SpringSecurityOAuth2Provider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.oauth2.provider.endpoint.FrameworkEndpointHandlerMapping;

@Configuration
@ConditionalOnProperty(name={"springdoc.api-docs.enabled"}, matchIfMissing=true)
public class SpringDocSecurityConfiguration {
    static {
        SpringDocUtils.getConfig().addRequestWrapperToIgnore(new Class[]{Authentication.class}).addResponseTypeToIgnore(Authentication.class).addAnnotationsToIgnore(new Class[]{AuthenticationPrincipal.class});
    }

    @Configuration
    @ConditionalOnBean(value={FrameworkEndpointHandlerMapping.class})
    class SpringSecurityOAuth2ProviderConfiguration {
        SpringSecurityOAuth2ProviderConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        SpringSecurityOAuth2Provider springSecurityOAuth2Provider(FrameworkEndpointHandlerMapping oauth2EndpointHandlerMapping) {
            return new SpringSecurityOAuth2Provider(oauth2EndpointHandlerMapping);
        }
    }
}

