/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.ui;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AbstractSwaggerWelcome
implements InitializingBean {
    protected final SwaggerUiConfigProperties swaggerUiConfig;
    protected final SpringDocConfigProperties springDocConfigProperties;
    protected String uiRootPath;
    @Value(value="${springdoc.swagger-ui.configUrl:#{null}}")
    private String originConfigUrl;
    @Value(value="${springdoc.swagger-ui.oauth2RedirectUrl:#{null}}")
    private String oauth2RedirectUrl;
    @Value(value="${springdoc.swagger-ui.url:#{null}}")
    private String swaggerUiUrl;

    public AbstractSwaggerWelcome(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties) {
        this.swaggerUiConfig = swaggerUiConfig;
        this.springDocConfigProperties = springDocConfigProperties;
    }

    public void afterPropertiesSet() {
        this.calculateUiRootPath(new StringBuilder[0]);
    }

    protected void calculateUiRootPath(StringBuilder ... sbUrls) {
        String swaggerPath;
        StringBuilder sbUrl = new StringBuilder();
        if (ArrayUtils.isNotEmpty((Object[])sbUrls)) {
            sbUrl = sbUrls[0];
        }
        if ((swaggerPath = this.swaggerUiConfig.getPath()).contains("/")) {
            sbUrl.append(swaggerPath, 0, swaggerPath.lastIndexOf("/"));
        }
        this.uiRootPath = sbUrl.toString();
    }

    protected String buildUrl(String contextPath, String docsUrl) {
        if (contextPath.endsWith("/")) {
            return contextPath.substring(0, contextPath.length() - 1) + docsUrl;
        }
        return contextPath + docsUrl;
    }

    void buildConfigUrl(String contextPath, UriComponentsBuilder uriComponentsBuilder) {
        String apiDocsUrl = this.springDocConfigProperties.getApiDocs().getPath();
        if (StringUtils.isEmpty((CharSequence)this.originConfigUrl)) {
            String url = this.buildUrl(contextPath, apiDocsUrl);
            String swaggerConfigUrl = url + "/" + "swagger-config";
            this.swaggerUiConfig.setConfigUrl(swaggerConfigUrl);
            if (SwaggerUiConfigProperties.getSwaggerUrls().isEmpty()) {
                if (StringUtils.isEmpty((CharSequence)this.swaggerUiUrl)) {
                    this.swaggerUiConfig.setUrl(url);
                } else {
                    this.swaggerUiConfig.setUrl(this.swaggerUiUrl);
                }
            } else {
                SwaggerUiConfigProperties.addUrl(url);
            }
        }
        if (StringUtils.isEmpty((CharSequence)this.oauth2RedirectUrl)) {
            this.swaggerUiConfig.setOauth2RedirectUrl(uriComponentsBuilder.path(this.uiRootPath).path("/swagger-ui/oauth2-redirect.html").build().toString());
        } else if (!this.swaggerUiConfig.isValidUrl(this.swaggerUiConfig.getOauth2RedirectUrl())) {
            this.swaggerUiConfig.setOauth2RedirectUrl(uriComponentsBuilder.path(this.uiRootPath).path(this.swaggerUiConfig.getOauth2RedirectUrl()).build().toString());
        }
    }
}

