/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springdoc.core.GenericParameterBuilder;
import org.springdoc.core.GenericReturnTypeParser;
import org.springdoc.core.GroupedOpenApi;
import org.springdoc.core.IgnoredParameterAnnotations;
import org.springdoc.core.IgnoredParameterAnnotationsDefault;
import org.springdoc.core.OpenAPIBuilder;
import org.springdoc.core.OperationBuilder;
import org.springdoc.core.PropertyResolverUtils;
import org.springdoc.core.RequestBodyBuilder;
import org.springdoc.core.SecurityOAuth2Provider;
import org.springdoc.core.SecurityParser;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.SpringDocUtils;
import org.springdoc.core.converters.AdditionalModelsConverter;
import org.springdoc.core.converters.ModelConverterRegistrar;
import org.springdoc.core.converters.PropertyCustomizingConverter;
import org.springdoc.core.converters.ResponseSupportConverter;
import org.springdoc.core.customizers.PropertyCustomizer;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;

@Configuration
@ConditionalOnProperty(name={"springdoc.api-docs.enabled"}, matchIfMissing=true)
public class SpringDocConfiguration {
    @Bean
    LocalVariableTableParameterNameDiscoverer localSpringDocParameterNameDiscoverer() {
        return new LocalVariableTableParameterNameDiscoverer();
    }

    @Bean
    AdditionalModelsConverter pageableSupportConverter() {
        return new AdditionalModelsConverter();
    }

    @Bean
    PropertyCustomizingConverter propertyCustomizingConverter(Optional<List<PropertyCustomizer>> customizers) {
        return new PropertyCustomizingConverter(customizers);
    }

    @Bean
    ResponseSupportConverter responseSupportConverter() {
        return new ResponseSupportConverter();
    }

    @Bean
    IgnoredParameterAnnotationsDefault ignoredParameterAnnotationsDefault() {
        return new IgnoredParameterAnnotationsDefault();
    }

    @Bean
    public OpenAPIBuilder openAPIBuilder(Optional<OpenAPI> openAPI, ApplicationContext context, SecurityParser securityParser, Optional<SecurityOAuth2Provider> springSecurityOAuth2Provider, SpringDocConfigProperties springDocConfigProperties) {
        return new OpenAPIBuilder(openAPI, context, securityParser, springSecurityOAuth2Provider, springDocConfigProperties);
    }

    @Bean
    public ModelConverterRegistrar modelConverterRegistrar(Optional<List<ModelConverter>> modelConverters) {
        return new ModelConverterRegistrar(modelConverters.orElse(Collections.emptyList()));
    }

    @Bean
    @ConditionalOnWebApplication
    public OperationBuilder operationBuilder(GenericParameterBuilder parameterBuilder, RequestBodyBuilder requestBodyBuilder, SecurityParser securityParser, PropertyResolverUtils propertyResolverUtils) {
        return new OperationBuilder(parameterBuilder, requestBodyBuilder, securityParser, propertyResolverUtils);
    }

    @Bean
    public PropertyResolverUtils propertyResolverUtils(ConfigurableBeanFactory factory) {
        return new PropertyResolverUtils(factory);
    }

    @Bean
    @ConditionalOnWebApplication
    public RequestBodyBuilder requestBodyBuilder(GenericParameterBuilder parameterBuilder) {
        return new RequestBodyBuilder(parameterBuilder);
    }

    @Bean
    public SecurityParser securityParser(PropertyResolverUtils propertyResolverUtils) {
        return new SecurityParser(propertyResolverUtils);
    }

    @Bean
    public GenericReturnTypeParser genericReturnTypeParser() {
        return new GenericReturnTypeParser();
    }

    @Bean
    public GenericParameterBuilder parameterBuilder(LocalVariableTableParameterNameDiscoverer localSpringDocParameterNameDiscoverer, IgnoredParameterAnnotations ignoredParameterAnnotations) {
        return new GenericParameterBuilder(localSpringDocParameterNameDiscoverer, ignoredParameterAnnotations);
    }

    static {
        SpringDocUtils.getConfig().replaceWithSchema(ObjectNode.class, (Schema)new ObjectSchema());
    }

    static class ConditionOnCacheOrGroupedOpenApi
    extends AnyNestedCondition {
        ConditionOnCacheOrGroupedOpenApi() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @Bean
        @ConditionalOnBean(value={GroupedOpenApi.class})
        public BeanFactoryPostProcessor beanFactoryPostProcessor1() {
            return this.getBeanFactoryPostProcessor();
        }

        @Bean
        @ConditionalOnProperty(name={"springdoc.cache.disabled"})
        @ConditionalOnMissingBean(value={GroupedOpenApi.class})
        public BeanFactoryPostProcessor beanFactoryPostProcessor2() {
            return this.getBeanFactoryPostProcessor();
        }

        private BeanFactoryPostProcessor getBeanFactoryPostProcessor() {
            return beanFactory -> {
                for (String beanName : beanFactory.getBeanNamesForType(OpenAPIBuilder.class)) {
                    beanFactory.getBeanDefinition(beanName).setScope("prototype");
                }
                for (String beanName : beanFactory.getBeanNamesForType(OpenAPI.class)) {
                    beanFactory.getBeanDefinition(beanName).setScope("prototype");
                }
            };
        }
    }
}

