/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.security.server.config;

import jakarta.servlet.Filter;
import org.springaicommunity.mcp.security.server.apikey.ApiKeyEntityRepository;
import org.springaicommunity.mcp.security.server.apikey.authentication.ApiKeyAuthenticationProvider;
import org.springaicommunity.mcp.security.server.apikey.web.ApiKeyAuthenticationFilter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.util.Assert;

public class McpApiKeyConfigurer
extends AbstractHttpConfigurer<McpApiKeyConfigurer, HttpSecurity> {
    private ApiKeyEntityRepository<?> apiKeyEntityRepository;
    private String headerName;
    private AuthenticationConverter authenticationConverter;

    public void init(HttpSecurity http) throws Exception {
        http.authenticationProvider(new ApiKeyAuthenticationProvider(this.apiKeyEntityRepository)).csrf(csrf -> csrf.ignoringRequestMatchers(new String[]{"/mcp"}));
    }

    public void configure(HttpSecurity http) throws Exception {
        Assert.notNull(this.apiKeyEntityRepository, (String)"apiKeyRepository must not be null");
        AuthenticationManager authManager = (AuthenticationManager)http.getSharedObject(AuthenticationManager.class);
        ApiKeyAuthenticationFilter filter = new ApiKeyAuthenticationFilter(authManager);
        if (this.headerName != null) {
            filter.setApiKeyHeader(this.headerName);
        }
        if (this.authenticationConverter != null) {
            filter.setAuthenticationConverter(this.authenticationConverter);
        }
        http.addFilterBefore((Filter)filter, BasicAuthenticationFilter.class);
    }

    public McpApiKeyConfigurer apiKeyRepository(ApiKeyEntityRepository<?> apiKeyEntityRepository) {
        this.apiKeyEntityRepository = apiKeyEntityRepository;
        return this;
    }

    public McpApiKeyConfigurer headerName(String headerName) {
        this.headerName = headerName;
        return this;
    }

    public McpApiKeyConfigurer authenticationConverter(AuthenticationConverter authenticationConverter) {
        this.authenticationConverter = authenticationConverter;
        return this;
    }

    public static McpApiKeyConfigurer mcpServerApiKey() {
        return new McpApiKeyConfigurer();
    }
}

