/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.security.server.apikey.memory;

import org.jspecify.annotations.Nullable;
import org.springaicommunity.mcp.security.server.apikey.ApiKeyEntity;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.Assert;

public class ApiKeyEntityImpl
implements ApiKeyEntity {
    private final String id;
    private @Nullable String secret;
    private final String name;

    private ApiKeyEntityImpl(String id, @Nullable String secret, String name) {
        this.id = id;
        this.secret = secret;
        this.name = name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public @Nullable String getSecret() {
        return this.secret;
    }

    public String getName() {
        return this.name;
    }

    public void eraseCredentials() {
        this.secret = null;
    }

    public ApiKeyEntityImpl copy() {
        return new ApiKeyEntityImpl(this.id, this.secret, this.name);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private @Nullable String id;
        private @Nullable String secret;
        private @Nullable String name;
        private PasswordEncoder passwordEncoder = PasswordEncoderFactories.createDelegatingPasswordEncoder();

        private Builder() {
        }

        public Builder passwordEncoder(PasswordEncoder encoder) {
            this.passwordEncoder = this.passwordEncoder;
            return this;
        }

        public Builder id(String id) {
            Assert.hasText((String)id, (String)"id must not be blank");
            this.id = id;
            return this;
        }

        public Builder secret(String secret) {
            Assert.hasText((String)secret, (String)"secret must not be blank");
            this.secret = secret;
            return this;
        }

        public Builder name(String name) {
            Assert.hasText((String)name, (String)"name must not be blank");
            this.name = name;
            return this;
        }

        public ApiKeyEntityImpl build() {
            Assert.hasText((String)this.id, (String)"id must not be blank");
            Assert.hasText((String)this.secret, (String)"secret must not be blank");
            Assert.hasText((String)this.name, (String)"name must not be blank");
            return new ApiKeyEntityImpl(this.id, this.passwordEncoder.encode((CharSequence)this.secret), this.name);
        }
    }
}

