/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.security.server.apikey.authentication;

import java.util.Collection;
import org.jspecify.annotations.Nullable;
import org.springaicommunity.mcp.security.server.apikey.ApiKey;
import org.springaicommunity.mcp.security.server.apikey.ApiKeyEntity;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.Transient;

@Transient
public class ApiKeyAuthenticationToken
extends AbstractAuthenticationToken {
    private final @Nullable ApiKeyEntity principal;
    private final @Nullable ApiKey credentials;

    private ApiKeyAuthenticationToken(ApiKey apiKey) {
        super(null);
        this.principal = null;
        this.credentials = apiKey;
        this.setAuthenticated(false);
    }

    private ApiKeyAuthenticationToken(ApiKeyEntity principal, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.principal = principal;
        this.credentials = null;
        this.setAuthenticated(true);
    }

    public static ApiKeyAuthenticationToken unauthenticated(ApiKey apiKey) {
        return new ApiKeyAuthenticationToken(apiKey);
    }

    public static ApiKeyAuthenticationToken authenticated(ApiKeyEntity principal, Collection<? extends GrantedAuthority> authorities) {
        return new ApiKeyAuthenticationToken(principal, authorities);
    }

    public @Nullable ApiKey getCredentials() {
        return this.credentials;
    }

    public @Nullable ApiKeyEntity getPrincipal() {
        return this.principal;
    }

    public String getName() {
        return this.credentials != null ? this.credentials.getId() : this.principal.getId();
    }
}

