/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.provider.resource;

import io.modelcontextprotocol.server.McpStatelessServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springaicommunity.mcp.McpPredicates;
import org.springaicommunity.mcp.annotation.McpResource;
import org.springaicommunity.mcp.method.resource.SyncStatelessMcpResourceMethodCallback;

public class SyncStatelessMcpResourceProvider {
    private static final Logger logger = LoggerFactory.getLogger(SyncStatelessMcpResourceProvider.class);
    private final List<Object> resourceObjects;

    public SyncStatelessMcpResourceProvider(List<Object> resourceObjects) {
        Assert.notNull(resourceObjects, (String)"resourceObjects cannot be null");
        this.resourceObjects = resourceObjects;
    }

    public List<McpStatelessServerFeatures.SyncResourceSpecification> getResourceSpecifications() {
        List<McpStatelessServerFeatures.SyncResourceSpecification> resourceSpecs = this.resourceObjects.stream().map(resourceObject -> Stream.of(this.doGetClassMethods(resourceObject)).filter(method -> method.isAnnotationPresent(McpResource.class)).filter(McpPredicates.filterReactiveReturnTypeMethod()).filter(McpPredicates.filterMethodWithBidirectionalParameters()).sorted((m1, m2) -> m1.getName().compareTo(m2.getName())).map(mcpResourceMethod -> {
            McpResource resourceAnnotation = this.doGetMcpResourceAnnotation((Method)mcpResourceMethod);
            String uri = resourceAnnotation.uri();
            if (McpPredicates.isUriTemplate(uri)) {
                return null;
            }
            String name = SyncStatelessMcpResourceProvider.getName(mcpResourceMethod, resourceAnnotation);
            String description = resourceAnnotation.description();
            String mimeType = resourceAnnotation.mimeType();
            McpSchema.Resource mcpResource = McpSchema.Resource.builder().uri(uri).name(name).description(description).mimeType(mimeType).build();
            SyncStatelessMcpResourceMethodCallback methodCallback = ((SyncStatelessMcpResourceMethodCallback.Builder)((SyncStatelessMcpResourceMethodCallback.Builder)((SyncStatelessMcpResourceMethodCallback.Builder)SyncStatelessMcpResourceMethodCallback.builder().method((Method)mcpResourceMethod)).bean(resourceObject)).resource(mcpResource)).build();
            McpStatelessServerFeatures.SyncResourceSpecification resourceSpec = new McpStatelessServerFeatures.SyncResourceSpecification(mcpResource, (BiFunction)methodCallback);
            return resourceSpec;
        }).filter(Objects::nonNull).toList()).flatMap(Collection::stream).toList();
        if (resourceSpecs.isEmpty()) {
            logger.warn("No resource methods found in the provided resource objects: {}", this.resourceObjects);
        }
        return resourceSpecs;
    }

    public List<McpStatelessServerFeatures.SyncResourceTemplateSpecification> getResourceTemplateSpecifications() {
        List<McpStatelessServerFeatures.SyncResourceTemplateSpecification> resourceSpecs = this.resourceObjects.stream().map(resourceObject -> Stream.of(this.doGetClassMethods(resourceObject)).filter(method -> method.isAnnotationPresent(McpResource.class)).filter(McpPredicates.filterReactiveReturnTypeMethod()).sorted((m1, m2) -> m1.getName().compareTo(m2.getName())).map(mcpResourceMethod -> {
            McpResource resourceAnnotation = this.doGetMcpResourceAnnotation((Method)mcpResourceMethod);
            String uri = resourceAnnotation.uri();
            if (!McpPredicates.isUriTemplate(uri)) {
                return null;
            }
            String name = SyncStatelessMcpResourceProvider.getName(mcpResourceMethod, resourceAnnotation);
            String description = resourceAnnotation.description();
            String mimeType = resourceAnnotation.mimeType();
            McpSchema.ResourceTemplate mcpResource = McpSchema.ResourceTemplate.builder().uriTemplate(uri).name(name).description(description).mimeType(mimeType).build();
            SyncStatelessMcpResourceMethodCallback methodCallback = ((SyncStatelessMcpResourceMethodCallback.Builder)((SyncStatelessMcpResourceMethodCallback.Builder)((SyncStatelessMcpResourceMethodCallback.Builder)SyncStatelessMcpResourceMethodCallback.builder().method((Method)mcpResourceMethod)).bean(resourceObject)).resource(mcpResource)).build();
            McpStatelessServerFeatures.SyncResourceTemplateSpecification resourceSpec = new McpStatelessServerFeatures.SyncResourceTemplateSpecification(mcpResource, (BiFunction)methodCallback);
            return resourceSpec;
        }).filter(Objects::nonNull).toList()).flatMap(Collection::stream).toList();
        if (resourceSpecs.isEmpty()) {
            logger.warn("No resource methods found in the provided resource objects: {}", this.resourceObjects);
        }
        return resourceSpecs;
    }

    protected Method[] doGetClassMethods(Object bean) {
        return bean.getClass().getDeclaredMethods();
    }

    protected McpResource doGetMcpResourceAnnotation(Method method) {
        return method.getAnnotation(McpResource.class);
    }

    private static String getName(Method method, McpResource resource) {
        Assert.notNull((Object)method, (String)"method cannot be null");
        if (resource == null || resource.name() == null || resource.name().isEmpty()) {
            return method.getName();
        }
        return resource.name();
    }
}

