/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.provider.sampling;

import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springaicommunity.mcp.annotation.McpSampling;
import org.springaicommunity.mcp.method.sampling.SyncMcpSamplingMethodCallback;
import org.springaicommunity.mcp.method.sampling.SyncSamplingSpecification;
import org.springaicommunity.mcp.provider.McpProviderUtils;

public class SyncMcpSamplingProvider {
    private static final Logger logger = LoggerFactory.getLogger(SyncMcpSamplingProvider.class);
    private final List<Object> samplingObjects;

    public SyncMcpSamplingProvider(List<Object> samplingObjects) {
        Assert.notNull(samplingObjects, (String)"samplingObjects cannot be null");
        this.samplingObjects = samplingObjects;
    }

    public List<SyncSamplingSpecification> getSamplingSpecifications() {
        List<SyncSamplingSpecification> samplingHandlers = this.samplingObjects.stream().map(samplingObject -> Stream.of(this.doGetClassMethods(samplingObject)).filter(method -> method.isAnnotationPresent(McpSampling.class)).filter(McpProviderUtils.filterReactiveReturnTypeMethod()).filter(method -> McpSchema.CreateMessageResult.class.isAssignableFrom(method.getReturnType())).filter(method -> method.getParameterCount() == 1 && McpSchema.CreateMessageRequest.class.isAssignableFrom(method.getParameterTypes()[0])).sorted((m1, m2) -> m1.getName().compareTo(m2.getName())).map(mcpSamplingMethod -> {
            McpSampling samplingAnnotation = mcpSamplingMethod.getAnnotation(McpSampling.class);
            SyncMcpSamplingMethodCallback methodCallback = ((SyncMcpSamplingMethodCallback.Builder)((SyncMcpSamplingMethodCallback.Builder)((SyncMcpSamplingMethodCallback.Builder)SyncMcpSamplingMethodCallback.builder().method((Method)mcpSamplingMethod)).bean(samplingObject)).sampling(samplingAnnotation)).build();
            return new SyncSamplingSpecification(samplingAnnotation.clients(), methodCallback);
        }).toList()).flatMap(Collection::stream).toList();
        if (samplingHandlers.isEmpty()) {
            logger.warn("No sampling methods found");
        }
        if (samplingHandlers.size() > 1) {
            logger.warn("Multiple sampling methods found: " + samplingHandlers.size());
        }
        return samplingHandlers;
    }

    protected Method[] doGetClassMethods(Object bean) {
        return bean.getClass().getDeclaredMethods();
    }
}

