/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.changed.resource;

import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import org.springaicommunity.mcp.annotation.McpResourceListChanged;

public abstract class AbstractMcpResourceListChangedMethodCallback {
    protected final Method method;
    protected final Object bean;

    protected AbstractMcpResourceListChangedMethodCallback(Method method, Object bean) {
        Assert.notNull((Object)method, (String)"Method can't be null!");
        Assert.notNull((Object)bean, (String)"Bean can't be null!");
        this.method = method;
        this.bean = bean;
        this.validateMethod(this.method);
    }

    protected void validateMethod(Method method) {
        if (method == null) {
            throw new IllegalArgumentException("Method must not be null");
        }
        this.validateReturnType(method);
        this.validateParameters(method);
    }

    protected abstract void validateReturnType(Method var1);

    protected void validateParameters(Method method) {
        Parameter[] parameters = method.getParameters();
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Method must have exactly 1 parameter (List<McpSchema.Resource>): " + method.getName() + " in " + method.getDeclaringClass().getName() + " has " + parameters.length + " parameters");
        }
        Class<?> paramType = parameters[0].getType();
        if (!List.class.isAssignableFrom(paramType)) {
            throw new IllegalArgumentException("Parameter must be of type List<McpSchema.Resource>: " + method.getName() + " in " + method.getDeclaringClass().getName() + " has parameter of type " + paramType.getName());
        }
    }

    protected Object[] buildArgs(Method method, Object exchange, List<McpSchema.Resource> updatedResources) {
        Parameter[] parameters = method.getParameters();
        Object[] args = new Object[parameters.length];
        args[0] = updatedResources;
        return args;
    }

    protected static abstract class AbstractBuilder<T extends AbstractBuilder<T, R>, R> {
        protected Method method;
        protected Object bean;

        protected AbstractBuilder() {
        }

        public T method(Method method) {
            this.method = method;
            return (T)this;
        }

        public T bean(Object bean) {
            this.bean = bean;
            return (T)this;
        }

        public T resourceListChanged(McpResourceListChanged resourceListChanged) {
            return (T)this;
        }

        protected void validate() {
            if (this.method == null) {
                throw new IllegalArgumentException("Method must not be null");
            }
            if (this.bean == null) {
                throw new IllegalArgumentException("Bean must not be null");
            }
        }

        public abstract R build();
    }

    public static class McpResourceListChangedConsumerMethodException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public McpResourceListChangedConsumerMethodException(String message, Throwable cause) {
            super(message, cause);
        }

        public McpResourceListChangedConsumerMethodException(String message) {
            super(message);
        }
    }
}

