/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.changed.resource;

import io.modelcontextprotocol.spec.McpSchema;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Function;
import org.springaicommunity.mcp.method.changed.resource.AbstractMcpResourceListChangedMethodCallback;
import reactor.core.publisher.Mono;

public final class AsyncMcpResourceListChangedMethodCallback
extends AbstractMcpResourceListChangedMethodCallback
implements Function<List<McpSchema.Resource>, Mono<Void>> {
    private AsyncMcpResourceListChangedMethodCallback(Builder builder) {
        super(builder.method, builder.bean);
    }

    @Override
    public Mono<Void> apply(List<McpSchema.Resource> updatedResources) {
        if (updatedResources == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Updated resources list must not be null"));
        }
        try {
            Object[] args = this.buildArgs(this.method, null, updatedResources);
            this.method.setAccessible(true);
            Object result = this.method.invoke(this.bean, args);
            if (result instanceof Mono) {
                Mono monoResult = (Mono)result;
                return monoResult.flatMap(value -> {
                    if (value != null) {
                        throw new ClassCastException("Expected Mono<Void> but got Mono<" + value.getClass().getName() + ">");
                    }
                    return Mono.empty();
                }).then();
            }
            return Mono.empty();
        }
        catch (Exception e) {
            return Mono.error((Throwable)new AbstractMcpResourceListChangedMethodCallback.McpResourceListChangedConsumerMethodException("Error invoking resource list changed consumer method: " + this.method.getName(), e));
        }
    }

    @Override
    protected void validateReturnType(Method method) {
        Class<?> returnType = method.getReturnType();
        if (returnType != Void.TYPE && !Mono.class.isAssignableFrom(returnType)) {
            throw new IllegalArgumentException("Method must have void or Mono<Void> return type: " + method.getName() + " in " + method.getDeclaringClass().getName() + " returns " + returnType.getName());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractMcpResourceListChangedMethodCallback.AbstractBuilder<Builder, AsyncMcpResourceListChangedMethodCallback> {
        @Override
        public AsyncMcpResourceListChangedMethodCallback build() {
            this.validate();
            return new AsyncMcpResourceListChangedMethodCallback(this);
        }
    }
}

