/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.provider.changed.tool;

import io.modelcontextprotocol.util.Assert;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.springaicommunity.mcp.annotation.McpToolListChanged;
import org.springaicommunity.mcp.method.changed.tool.AsyncMcpToolListChangedMethodCallback;
import org.springaicommunity.mcp.method.changed.tool.AsyncToolListChangedSpecification;
import reactor.core.publisher.Mono;

public class AsyncMcpToolListChangedProvider {
    private final List<Object> toolListChangedConsumerObjects;

    public AsyncMcpToolListChangedProvider(List<Object> toolListChangedConsumerObjects) {
        Assert.notNull(toolListChangedConsumerObjects, (String)"toolListChangedConsumerObjects cannot be null");
        this.toolListChangedConsumerObjects = toolListChangedConsumerObjects;
    }

    public List<AsyncToolListChangedSpecification> getToolListChangedSpecifications() {
        List<AsyncToolListChangedSpecification> toolListChangedConsumers = this.toolListChangedConsumerObjects.stream().map(consumerObject -> Stream.of(this.doGetClassMethods(consumerObject)).filter(method -> method.isAnnotationPresent(McpToolListChanged.class)).filter(method -> method.getReturnType() == Void.TYPE || Mono.class.isAssignableFrom(method.getReturnType())).map(mcpToolListChangedConsumerMethod -> {
            McpToolListChanged toolListChangedAnnotation = mcpToolListChangedConsumerMethod.getAnnotation(McpToolListChanged.class);
            AsyncMcpToolListChangedMethodCallback methodCallback = ((AsyncMcpToolListChangedMethodCallback.Builder)((AsyncMcpToolListChangedMethodCallback.Builder)AsyncMcpToolListChangedMethodCallback.builder().method((Method)mcpToolListChangedConsumerMethod)).bean(consumerObject)).build();
            return new AsyncToolListChangedSpecification(toolListChangedAnnotation.clients(), methodCallback);
        }).toList()).flatMap(Collection::stream).toList();
        return toolListChangedConsumers;
    }

    protected Method[] doGetClassMethods(Object bean) {
        return bean.getClass().getDeclaredMethods();
    }
}

