/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.resource;

import io.modelcontextprotocol.common.McpTransportContext;
import io.modelcontextprotocol.spec.McpSchema;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.springaicommunity.mcp.method.resource.AbstractMcpResourceMethodCallback;
import org.springaicommunity.mcp.method.resource.DefaultMcpReadResourceResultConverter;

public final class SyncStatelessMcpResourceMethodCallback
extends AbstractMcpResourceMethodCallback
implements BiFunction<McpTransportContext, McpSchema.ReadResourceRequest, McpSchema.ReadResourceResult> {
    private SyncStatelessMcpResourceMethodCallback(Builder builder) {
        super(builder.method, builder.bean, builder.uri, builder.name, builder.description, builder.mimeType, builder.resultConverter, builder.uriTemplateManagerFactory, builder.contentType);
        this.validateMethod(this.method);
    }

    @Override
    public McpSchema.ReadResourceResult apply(McpTransportContext context, McpSchema.ReadResourceRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("Request must not be null");
        }
        try {
            Map uriVariableValues = this.uriTemplateManager.extractVariableValues(request.uri());
            if (!this.uriVariables.isEmpty() && uriVariableValues.size() != this.uriVariables.size()) {
                throw new IllegalArgumentException("Failed to extract all URI variables from request URI: " + request.uri() + ". Expected variables: " + String.valueOf(this.uriVariables) + ", but found: " + String.valueOf(uriVariableValues.keySet()));
            }
            Object[] args = this.buildArgs(this.method, context, request, uriVariableValues);
            this.method.setAccessible(true);
            Object result = this.method.invoke(this.bean, args);
            return this.resultConverter.convertToReadResourceResult(result, request.uri(), this.mimeType, this.contentType);
        }
        catch (Exception e) {
            throw new AbstractMcpResourceMethodCallback.McpResourceMethodException("Access error invoking resource method: " + this.method.getName(), e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void validateReturnType(Method method) {
        boolean validReturnType;
        Class<?> returnType = method.getReturnType();
        boolean bl = validReturnType = McpSchema.ReadResourceResult.class.isAssignableFrom(returnType) || List.class.isAssignableFrom(returnType) || McpSchema.ResourceContents.class.isAssignableFrom(returnType) || String.class.isAssignableFrom(returnType);
        if (!validReturnType) {
            throw new IllegalArgumentException("Method must return either ReadResourceResult, List<ResourceContents>, List<String>, ResourceContents, or String: " + method.getName() + " in " + method.getDeclaringClass().getName() + " returns " + returnType.getName());
        }
    }

    @Override
    protected boolean isExchangeOrContextType(Class<?> paramType) {
        return McpTransportContext.class.isAssignableFrom(paramType);
    }

    public static class Builder
    extends AbstractMcpResourceMethodCallback.AbstractBuilder<Builder, SyncStatelessMcpResourceMethodCallback> {
        private Builder() {
            this.resultConverter = new DefaultMcpReadResourceResultConverter();
        }

        @Override
        public SyncStatelessMcpResourceMethodCallback build() {
            this.validate();
            return new SyncStatelessMcpResourceMethodCallback(this);
        }
    }
}

