/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.specs2.control.eff.Eff;
import org.specs2.control.eff.Eff$;
import org.specs2.control.eff.Evaluate;
import org.specs2.control.eff.Fx1;
import org.specs2.control.eff.Fx3;
import org.specs2.control.eff.FxAppend;
import org.specs2.control.eff.MemberIn$;
import org.specs2.control.eff.MemberInOut$;
import org.specs2.control.eff.Safe;
import org.specs2.control.eff.Writer;
import org.specs2.control.eff.syntax.all$;
import org.specs2.control.package$Operations$;
import org.specs2.fp.Traverse$;
import org.specs2.fp.package;
import org.specs2.io.DirectoryPath;
import org.specs2.io.FilePath;
import org.specs2.io.FileSystem;
import org.specs2.io.FileSystem$;
import org.specs2.io.FileSystem$copyLock$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Right$;

public abstract class FileSystem$class {
    public static Eff deleteFile(FileSystem $this, FilePath filePath) {
        return package$Operations$.MODULE$.delayed(new Serializable($this, filePath){
            public static final long serialVersionUID = 0L;
            private final FilePath filePath$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.filePath$1.toFile().delete();
            }
            {
                this.filePath$1 = filePath$1;
            }
        });
    }

    public static Eff updateFileContent(FileSystem $this, FilePath filePath, Function1 update) {
        return $this.readFile(filePath).flatMap(new Serializable($this, filePath, update){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystem $outer;
            private final FilePath filePath$2;
            private final Function1 update$1;

            public final Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> apply(String s) {
                return this.$outer.writeFile(this.filePath$2, (String)this.update$1.apply((Object)s));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.filePath$2 = filePath$2;
                this.update$1 = update$1;
            }
        });
    }

    public static Eff replaceInFile(FileSystem $this, FilePath filePath, String source, String target) {
        return $this.updateFileContent(filePath, (Function1<String, String>)new Serializable($this, source, target){
            public static final long serialVersionUID = 0L;
            private final String source$1;
            private final String target$1;

            public final String apply(String x$1) {
                return x$1.replace(this.source$1, this.target$1);
            }
            {
                this.source$1 = source$1;
                this.target$1 = target$1;
            }
        });
    }

    public static Eff writeFile(FileSystem $this, FilePath filePath, String content) {
        return (Eff)package.syntax$.MODULE$.MonadOps($this.mkdirs(filePath), Eff$.MODULE$.EffMonad()).$greater$greater(package$Operations$.MODULE$.protect(new Serializable($this, filePath, content){
            public static final long serialVersionUID = 0L;
            private final FilePath filePath$3;
            private final String content$1;

            public final Product apply() {
                Left left;
                PrintWriter writer2 = new PrintWriter(this.filePath$3.path(), "UTF-8");
                try {
                    try {
                        Right$ right$ = package$.MODULE$.Right();
                        writer2.write(this.content$1);
                        left = right$.apply((Object)BoxedUnit.UNIT);
                    }
                    catch (Exception exception) {
                        left = package$.MODULE$.Left().apply((Object)exception);
                    }
                }
                finally {
                    writer2.close();
                }
                return left;
            }
            {
                this.filePath$3 = filePath$3;
                this.content$1 = content$1;
            }
        }).flatMap(new Serializable($this, filePath){
            public static final long serialVersionUID = 0L;
            private final FilePath filePath$3;

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Eff apply(Either x0$1) {
                Either either;
                block4: {
                    Eff eff2;
                    block3: {
                        block2: {
                            either = x0$1;
                            if (!(either instanceof Left)) break block2;
                            Left left = (Left)either;
                            Exception e = (Exception)left.a();
                            eff2 = (Eff)package.syntax$.MODULE$.MonadOps(package$Operations$.MODULE$.logThrowable(e, MemberIn$.MODULE$.MemberInAppendR(MemberIn$.MODULE$.MemberIn3L())), Eff$.MODULE$.EffMonad()).$greater$greater(package$Operations$.MODULE$.warn(new StringBuilder().append((Object)"could not write file ").append((Object)this.filePath$3.path()).toString()));
                            break block3;
                        }
                        if (!(either instanceof Right)) break block4;
                        eff2 = package$Operations$.MODULE$.unit();
                    }
                    return eff2;
                }
                throw new MatchError((Object)either);
            }
            {
                this.filePath$3 = filePath$3;
            }
        }));
    }

    public static Eff withEphemeralFile(FileSystem $this, FilePath path2, Eff operation) {
        return all$.MODULE$.SafeEffectOps(operation).thenFinally((Eff)package.syntax$.MODULE$.FunctorOps($this.deleteFile(path2), Eff$.MODULE$.EffMonad()).void(), MemberInOut$.MODULE$.MemberInOutAppendR(MemberInOut$.MODULE$.MemberInOut3R()));
    }

    public static Eff mkdirs(FileSystem $this, DirectoryPath path2) {
        return (Eff)package.syntax$.MODULE$.FunctorOps(package$Operations$.MODULE$.protect(new Serializable($this, path2){
            public static final long serialVersionUID = 0L;
            private final DirectoryPath path$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.path$1.toFile().mkdirs();
            }
            {
                this.path$1 = path$1;
            }
        }), Eff$.MODULE$.EffMonad()).void();
    }

    public static Eff mkdirs(FileSystem $this, FilePath path2) {
        return $this.mkdirs(path2.dir());
    }

    public static Eff unjar(FileSystem $this, URL jarUrl, DirectoryPath dest, String regexFilter) {
        Pattern regex = Pattern.compile(regexFilter);
        InputStream uis = jarUrl.openStream();
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(uis));
        return package$Operations$.MODULE$.delayed(new Serializable($this, regex, zis, dest){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystem $outer;
            private final Pattern regex$1;
            private final ZipInputStream zis$1;
            private final DirectoryPath dest$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                try {
                    FileSystem$class.extractEntry$1(this.$outer, this.zis$1.getNextEntry(), this.regex$1, this.zis$1, this.dest$1);
                    return;
                }
                finally {
                    this.zis$1.close();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.regex$1 = regex$1;
                this.zis$1 = zis$1;
                this.dest$1 = dest$1;
            }
        });
    }

    private static void copy(FileSystem $this, InputStream input, OutputStream output) {
        byte[] data = new byte[2048];
        FileSystem$class.readData$1($this, input.read(data, 0, 2048), input, output, data);
    }

    public static Eff copyDir(FileSystem $this, DirectoryPath src, DirectoryPath dest) {
        return (Eff)package.syntax$.MODULE$.MonadOps(package.syntax$.MODULE$.MonadOps($this.mkdirs(dest), Eff$.MODULE$.EffMonad()).$greater$greater($this.listDirectFilePaths(src).flatMap(new Serializable($this, dest){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystem $outer;
            public final DirectoryPath dest$2;

            public final Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> apply(IndexedSeq<FilePath> files) {
                return (Eff)package.syntax$.MODULE$.FunctorOps(package.syntax$.MODULE$.SequenceOps(files.toList().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FileSystem$.anonfun.copyDir.1 $outer;

                    public final Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> apply(FilePath filePath) {
                        return this.$outer.org$specs2$io$FileSystem$$anonfun$$$outer().copyFile(this.$outer.dest$2, filePath);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, List$.MODULE$.canBuildFrom()), Traverse$.MODULE$.listInstance(), Eff$.MODULE$.EffMonad()).sequence(), Eff$.MODULE$.EffMonad()).void();
            }

            public /* synthetic */ FileSystem org$specs2$io$FileSystem$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dest$2 = dest$2;
            }
        })), Eff$.MODULE$.EffMonad()).$greater$greater($this.listDirectDirectoryPaths(src).flatMap(new Serializable($this, dest){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystem $outer;
            public final DirectoryPath dest$2;

            public final Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> apply(IndexedSeq<DirectoryPath> directories) {
                return (Eff)package.syntax$.MODULE$.FunctorOps(package.syntax$.MODULE$.SequenceOps(directories.toList().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FileSystem$.anonfun.copyDir.2 $outer;

                    public final Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> apply(DirectoryPath dir2) {
                        return this.$outer.org$specs2$io$FileSystem$$anonfun$$$outer().copyDir(dir2, this.$outer.dest$2.$div(dir2.name()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, List$.MODULE$.canBuildFrom()), Traverse$.MODULE$.listInstance(), Eff$.MODULE$.EffMonad()).sequence(), Eff$.MODULE$.EffMonad()).void();
            }

            public /* synthetic */ FileSystem org$specs2$io$FileSystem$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dest$2 = dest$2;
            }
        }));
    }

    public static Eff copyFile(FileSystem $this, DirectoryPath dest, FilePath filePath) {
        return (Eff)package.syntax$.MODULE$.MonadOps($this.mkdirs(dest), Eff$.MODULE$.EffMonad()).$greater$greater(package.syntax$.MODULE$.FunctorOps(package$Operations$.MODULE$.delayed(new Serializable($this, dest, filePath){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystem $outer;
            private final DirectoryPath dest$3;
            private final FilePath filePath$4;

            public final Path apply() {
                FileSystem$copyLock$ fileSystem$copyLock$ = this.$outer.org$specs2$io$FileSystem$$copyLock();
                synchronized (fileSystem$copyLock$) {
                    Path path2 = Files.copy(Paths.get(this.filePath$4.path(), new String[0]), Paths.get(this.dest$3.path(), new String[0]).resolve(Paths.get(this.filePath$4.name().name(), new String[0])), StandardCopyOption.REPLACE_EXISTING);
                    return path2;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dest$3 = dest$3;
                this.filePath$4 = filePath$4;
            }
        }), Eff$.MODULE$.EffMonad()).void());
    }

    public static Eff createFile(FileSystem $this, FilePath filePath) {
        return (Eff)package.syntax$.MODULE$.MonadOps($this.mkdirs(filePath.dir()), Eff$.MODULE$.EffMonad()).$greater$greater(package$Operations$.MODULE$.delayed(new Serializable($this, filePath){
            public static final long serialVersionUID = 0L;
            private final FilePath filePath$5;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.filePath$5.toFile().createNewFile();
            }
            {
                this.filePath$5 = filePath$5;
            }
        }));
    }

    public static Eff delete(FileSystem $this, FilePath file2) {
        return (Eff)package.syntax$.MODULE$.FunctorOps(package$Operations$.MODULE$.delayed(new Serializable($this, file2){
            public static final long serialVersionUID = 0L;
            private final FilePath file$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.file$1.toFile().delete();
            }
            {
                this.file$1 = file$1;
            }
        }), Eff$.MODULE$.EffMonad()).void();
    }

    public static Eff delete(FileSystem $this, DirectoryPath dir2) {
        return (Eff)package.syntax$.MODULE$.MonadOps($this.listFilePaths(dir2).flatMap(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystem $outer;

            public final Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> apply(List<FilePath> x$2) {
                return (Eff)package.syntax$.MODULE$.FunctorOps(package.syntax$.MODULE$.SequenceOps((Object)((List)x$2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FileSystem$.anonfun.delete.2 $outer;

                    public final Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> apply(FilePath file2) {
                        return this.$outer.org$specs2$io$FileSystem$$anonfun$$$outer().delete(file2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, List$.MODULE$.canBuildFrom())).toList(), Traverse$.MODULE$.listInstance(), Eff$.MODULE$.EffMonad()).sequence(), Eff$.MODULE$.EffMonad()).void();
            }

            public /* synthetic */ FileSystem org$specs2$io$FileSystem$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }), Eff$.MODULE$.EffMonad()).$greater$greater($this.delete(dir2.toFilePath()));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void extractEntry$1(FileSystem $this, ZipEntry entry, Pattern regex$1, ZipInputStream zis$1, DirectoryPath dest$1) {
        while (true) {
            if (entry == null) {
                return;
            }
            Matcher matcher = regex$1.matcher(entry.getName());
            if (matcher.matches()) {
                String target = matcher.replaceFirst(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "$1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Matcher.quoteReplacement(dest$1.path())})));
                if (!entry.isDirectory()) {
                    new File(target).getParentFile().mkdirs();
                    new File(target).createNewFile();
                    FileOutputStream fos = new FileOutputStream(target);
                    BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
                    try {
                        FileSystem$class.copy($this, zis$1, dest);
                        dest.flush();
                    }
                    catch (Throwable throwable) {
                        void var9_8;
                        var9_8.close();
                        throw throwable;
                    }
                    dest.close();
                }
            }
            entry = zis$1.getNextEntry();
        }
    }

    private static final void readData$1(FileSystem $this, int count, InputStream input$1, OutputStream output$1, byte[] data$1) {
        while (count != -1) {
            output$1.write(data$1, 0, count);
            output$1.flush();
            count = input$1.read(data$1, 0, 2048);
        }
    }

    public static void $init$(FileSystem $this) {
    }
}

