/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.xml;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonarsource.analyzer.commons.xml.PrologElement;
import org.sonarsource.analyzer.commons.xml.XmlParser;
import org.sonarsource.analyzer.commons.xml.XmlTextRange;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlFile {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final String ELEMENT = "element";
    private InputFile inputFile;
    private Document documentNamespaceAware;
    private Document documentNamespaceUnaware;
    private String contents;
    private Charset charset;
    private PrologElement prologElement = null;

    void setDocument(Document document, boolean namespaceAware) {
        if (namespaceAware) {
            this.documentNamespaceAware = document;
        } else {
            this.documentNamespaceUnaware = document;
        }
    }

    void setPrologElement(PrologElement prologElement) {
        this.prologElement = prologElement;
    }

    private XmlFile(InputFile inputFile) throws IOException {
        this.inputFile = inputFile;
        this.contents = inputFile.contents();
        this.charset = inputFile.charset();
    }

    private XmlFile(String str) {
        this.inputFile = null;
        this.contents = str;
        this.charset = DEFAULT_CHARSET;
    }

    public static XmlFile create(InputFile inputFile) throws IOException {
        XmlFile xmlFile = new XmlFile(inputFile);
        new XmlParser(xmlFile, true);
        return xmlFile;
    }

    public static XmlFile create(String str) {
        XmlFile xmlFile = new XmlFile(str);
        new XmlParser(xmlFile, true);
        return xmlFile;
    }

    @Nullable
    public InputFile getInputFile() {
        return this.inputFile;
    }

    public String getContents() {
        return this.contents;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public Document getDocument() {
        return this.getNamespaceAwareDocument();
    }

    public Document getNamespaceAwareDocument() {
        return this.documentNamespaceAware;
    }

    public Document getNamespaceUnawareDocument() {
        if (this.documentNamespaceUnaware == null) {
            new XmlParser(this, false);
        }
        return this.documentNamespaceUnaware;
    }

    public Optional<PrologElement> getPrologElement() {
        return Optional.ofNullable(this.prologElement);
    }

    public static XmlTextRange startLocation(CDATASection node) {
        return XmlFile.getRangeOrThrow(node, Location.START, "CDATA");
    }

    public static XmlTextRange endLocation(CDATASection node) {
        return XmlFile.getRangeOrThrow(node, Location.END, "CDATA");
    }

    public static XmlTextRange startLocation(Element node) {
        return XmlFile.getRangeOrThrow(node, Location.START, ELEMENT);
    }

    public static XmlTextRange endLocation(Element node) {
        return XmlFile.getRangeOrThrow(node, Location.END, ELEMENT);
    }

    public static XmlTextRange nameLocation(Element node) {
        return XmlFile.getRangeOrThrow(node, Location.NAME, ELEMENT);
    }

    public static XmlTextRange attributeNameLocation(Attr node) {
        return XmlFile.getRangeOrThrow(node, Location.NAME, "attribute");
    }

    public static XmlTextRange attributeValueLocation(Attr node) {
        return XmlFile.getRangeOrThrow(node, Location.VALUE, "attribute");
    }

    public static XmlTextRange nodeLocation(Node node) {
        return XmlFile.getRangeOrThrow(node, Location.NODE, "");
    }

    public static Optional<XmlTextRange> getRange(Node node, Location location) {
        return Optional.ofNullable((XmlTextRange)node.getUserData(location.name()));
    }

    private static XmlTextRange getRangeOrThrow(Node node, Location location, String nodeType) {
        return XmlFile.getRange(node, location).orElseThrow(() -> new IllegalStateException(String.format("Missing %s location on XML %s node", location.name().toLowerCase(Locale.ENGLISH), nodeType)));
    }

    public static List<Node> children(Node node) {
        return XmlFile.asList(node.getChildNodes());
    }

    public static List<Node> asList(@Nullable NodeList nodeList) {
        if (nodeList == null) {
            return Collections.emptyList();
        }
        int numberResults = nodeList.getLength();
        if (numberResults == 0) {
            return Collections.emptyList();
        }
        return IntStream.range(0, numberResults).mapToObj(nodeList::item).collect(Collectors.toList());
    }

    @CheckForNull
    public static Node nodeAttribute(Node node, String attribute) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return null;
        }
        return attributes.getNamedItem(attribute);
    }

    public static enum Location {
        NODE,
        START,
        END,
        NAME,
        VALUE;

    }
}

