/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.api.SonarRuntime;
import org.sonar.api.server.profile.BuiltInQualityProfilesDefinition;
import org.sonarsource.analyzer.commons.JsonParser;
import org.sonarsource.analyzer.commons.Resources;
import org.sonarsource.analyzer.commons.RuleMetadataLoader;

public final class BuiltInQualityProfileJsonLoader {
    private BuiltInQualityProfileJsonLoader() {
    }

    public static void load(BuiltInQualityProfilesDefinition.NewBuiltInQualityProfile profile, String repositoryKey, String jsonProfilePath) {
        Set<String> activeKeys = BuiltInQualityProfileJsonLoader.loadActiveKeysFromJsonProfile(jsonProfilePath);
        for (String activeKey : activeKeys) {
            profile.activateRule(repositoryKey, activeKey);
        }
    }

    public static void load(BuiltInQualityProfilesDefinition.NewBuiltInQualityProfile profile, String repositoryKey, String jsonProfilePath, String resourcePath, SonarRuntime sonarRuntime) {
        RuleMetadataLoader ruleMetadataLoader = new RuleMetadataLoader(resourcePath, jsonProfilePath, sonarRuntime);
        Set<String> activeKeys = BuiltInQualityProfileJsonLoader.loadActiveKeysFromJsonProfile(jsonProfilePath);
        activeKeys.stream().filter(ruleKey -> {
            Map<String, Object> ruleMetadata = ruleMetadataLoader.getMetadata((String)ruleKey);
            return !ruleMetadataLoader.isSecurityHotspot(ruleMetadata) || ruleMetadataLoader.securityHotspotsSupported();
        }).forEach(activeKey -> profile.activateRule(repositoryKey, activeKey));
    }

    static Set<String> loadActiveKeysFromJsonProfile(String profilePath) {
        Map<String, Object> root;
        JsonParser jsonParser = new JsonParser();
        try {
            root = jsonParser.parse(Resources.toString(profilePath, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't read resource: " + profilePath, e);
        }
        List ruleKeys = (List)root.get("ruleKeys");
        if (ruleKeys == null) {
            throw new IllegalStateException("missing 'ruleKeys'");
        }
        return new HashSet<String>(ruleKeys);
    }
}

