/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.measures.Metric;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.xml.Utils;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.XmlTextRange;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class LineCounter {
    private static final Logger LOG = Loggers.get(LineCounter.class);

    private LineCounter() {
    }

    private static <T extends Serializable> void saveMeasure(SensorContext context, InputFile inputFile, Metric<T> metric, T value) {
        context.newMeasure().withValue(value).forMetric(metric).on((InputComponent)inputFile).save();
    }

    public static void analyse(SensorContext context, FileLinesContextFactory fileLinesContextFactory, XmlFile xmlFile) {
        LOG.debug("Count lines in {}", (Object)xmlFile.getInputFile().uri());
        HashSet<Integer> linesOfCode = new HashSet<Integer>();
        HashSet<Integer> commentLines = new HashSet<Integer>();
        Document document = xmlFile.getDocument();
        LineCounter.visitNode(document, linesOfCode, commentLines);
        xmlFile.getPrologElement().ifPresent(prologElement -> LineCounter.addLinesRange(linesOfCode, prologElement.getPrologStartLocation().getStartLine(), prologElement.getPrologEndLocation().getEndLine()));
        FileLinesContext fileLinesContext = fileLinesContextFactory.createFor(xmlFile.getInputFile());
        linesOfCode.forEach(lineOfCode -> fileLinesContext.setIntValue("ncloc_data", lineOfCode.intValue(), 1));
        fileLinesContext.save();
        LineCounter.saveMeasure(context, xmlFile.getInputFile(), CoreMetrics.COMMENT_LINES, commentLines.size());
        LineCounter.saveMeasure(context, xmlFile.getInputFile(), CoreMetrics.NCLOC, linesOfCode.size());
    }

    private static void visitNode(Node node, Set<Integer> linesOfCode, Set<Integer> commentLines) {
        XmlTextRange range = XmlFile.nodeLocation(node);
        switch (node.getNodeType()) {
            case 1: {
                LineCounter.addLinesRange(linesOfCode, XmlFile.startLocation((Element)node));
                LineCounter.addLinesRange(linesOfCode, XmlFile.endLocation((Element)node));
                break;
            }
            case 8: {
                LineCounter.addNotEmptyLines(commentLines, node.getTextContent(), range);
                break;
            }
            case 3: 
            case 4: {
                LineCounter.addNotEmptyLines(linesOfCode, node.getTextContent(), range);
                break;
            }
            case 10: {
                LineCounter.addLinesRange(linesOfCode, range);
                break;
            }
        }
        XmlFile.children(node).forEach(child -> LineCounter.visitNode(child, linesOfCode, commentLines));
    }

    private static void addNotEmptyLines(Set<Integer> set, String text, XmlTextRange fullTextRange) {
        int lineNumber = fullTextRange.getStartLine();
        for (String line : Utils.splitLines(text)) {
            if (!line.trim().isEmpty()) {
                set.add(lineNumber);
            }
            ++lineNumber;
        }
    }

    private static void addLinesRange(Set<Integer> set, int start, int end) {
        for (int line = start; line <= end; ++line) {
            set.add(line);
        }
    }

    private static void addLinesRange(Set<Integer> set, XmlTextRange range) {
        LineCounter.addLinesRange(set, range.getStartLine(), range.getEndLine());
    }
}

