/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.ws;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.ExtensionPoint;
import org.sonar.api.internal.apachecommons.io.FilenameUtils;
import org.sonar.api.internal.apachecommons.io.IOUtils;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.server.ServerSide;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Definable;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.utils.Preconditions;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

@ServerSide
@ExtensionPoint
public interface WebService
extends Definable<Context> {
    @Override
    public void define(Context var1);

    @Immutable
    public static class Param {
        public static final String TEXT_QUERY = "q";
        public static final String PAGE = "p";
        public static final String PAGE_SIZE = "ps";
        public static final String FIELDS = "f";
        public static final String SORT = "s";
        public static final String ASCENDING = "asc";
        public static final String FACETS = "facets";
        public static final String SELECTED = "selected";
        private final String key;
        private final String since;
        private final String deprecatedSince;
        private final String deprecatedKey;
        private final String deprecatedKeySince;
        private final String description;
        private final String exampleValue;
        private final String defaultValue;
        private final boolean required;
        private final boolean internal;
        private final Set<String> possibleValues;
        private final Integer maximumLength;
        private final Integer minimumLength;
        private final Integer maximumValue;
        private final Integer maxValuesAllowed;

        protected Param(Action action, NewParam newParam) {
            this.key = newParam.key;
            this.since = newParam.since;
            this.deprecatedSince = newParam.deprecatedSince;
            this.deprecatedKey = newParam.deprecatedKey;
            this.deprecatedKeySince = newParam.deprecatedKeySince;
            this.description = newParam.description;
            this.exampleValue = newParam.exampleValue;
            this.defaultValue = newParam.defaultValue;
            this.required = newParam.required;
            this.internal = newParam.internal;
            this.possibleValues = newParam.possibleValues;
            this.maxValuesAllowed = newParam.maxValuesAllowed;
            this.maximumLength = newParam.maximumLength;
            this.minimumLength = newParam.minimumLength;
            this.maximumValue = newParam.maximumValue;
            Preconditions.checkArgument(!this.required || this.defaultValue == null, "Default value must not be set on parameter '%s?%s' as it's marked as required", action, this.key);
        }

        public String key() {
            return this.key;
        }

        @CheckForNull
        public String since() {
            return this.since;
        }

        @CheckForNull
        public String deprecatedSince() {
            return this.deprecatedSince;
        }

        @CheckForNull
        public String deprecatedKey() {
            return this.deprecatedKey;
        }

        @CheckForNull
        public String deprecatedKeySince() {
            return this.deprecatedKeySince;
        }

        @CheckForNull
        public String description() {
            return this.description;
        }

        @CheckForNull
        public String exampleValue() {
            return this.exampleValue;
        }

        public boolean isRequired() {
            return this.required;
        }

        public boolean isInternal() {
            return this.internal;
        }

        @CheckForNull
        public Set<String> possibleValues() {
            return this.possibleValues;
        }

        @CheckForNull
        public String defaultValue() {
            return this.defaultValue;
        }

        public Integer maxValuesAllowed() {
            return this.maxValuesAllowed;
        }

        @CheckForNull
        public Integer maximumLength() {
            return this.maximumLength;
        }

        @CheckForNull
        public Integer minimumLength() {
            return this.minimumLength;
        }

        @CheckForNull
        public Integer maximumValue() {
            return this.maximumValue;
        }

        public String toString() {
            return this.key;
        }
    }

    public static enum SelectionMode {
        SELECTED("selected"),
        DESELECTED("deselected"),
        ALL("all");

        private final String paramValue;
        private static final Map<String, SelectionMode> BY_VALUE;

        private SelectionMode(String paramValue) {
            this.paramValue = paramValue;
        }

        public String value() {
            return this.paramValue;
        }

        public static SelectionMode fromParam(String paramValue) {
            Preconditions.checkArgument(BY_VALUE.containsKey(paramValue));
            return BY_VALUE.get(paramValue);
        }

        public static Collection<String> possibleValues() {
            return BY_VALUE.keySet();
        }

        static {
            BY_VALUE = Arrays.stream(SelectionMode.values()).collect(Collectors.toMap(v -> v.paramValue, v -> v));
        }
    }

    public static class NewParam {
        private String key;
        private String since;
        private String deprecatedSince;
        private String deprecatedKey;
        private String deprecatedKeySince;
        private String description;
        private String exampleValue;
        private String defaultValue;
        private boolean required = false;
        private boolean internal = false;
        private Set<String> possibleValues = null;
        private Integer maxValuesAllowed;
        private Integer maximumLength;
        private Integer minimumLength;
        private Integer maximumValue;

        private NewParam(String key) {
            this.key = key;
        }

        public NewParam setSince(@Nullable String since) {
            this.since = since;
            return this;
        }

        public NewParam setDeprecatedSince(@Nullable String deprecatedSince) {
            this.deprecatedSince = deprecatedSince;
            return this;
        }

        public NewParam setDeprecatedKey(@Nullable String key, @Nullable String deprecatedSince) {
            this.deprecatedKey = key;
            this.deprecatedKeySince = deprecatedSince;
            return this;
        }

        public NewParam setDescription(@Nullable String description) {
            this.description = description;
            return this;
        }

        public NewParam setDescription(@Nullable String description, Object ... descriptionArgument) {
            this.description = description == null ? null : String.format(description, descriptionArgument);
            return this;
        }

        public NewParam setRequired(boolean b) {
            this.required = b;
            return this;
        }

        public NewParam setInternal(boolean b) {
            this.internal = b;
            return this;
        }

        public NewParam setExampleValue(@Nullable Object s) {
            this.exampleValue = s != null ? s.toString() : null;
            return this;
        }

        public <T> NewParam setPossibleValues(T ... values) {
            return this.setPossibleValues(values == null ? Collections.emptyList() : Arrays.asList(values));
        }

        public NewParam setBooleanPossibleValues() {
            return this.setPossibleValues("true", "false", "yes", "no");
        }

        public <T> NewParam setPossibleValues(@Nullable Collection<T> values) {
            if (values == null || values.isEmpty()) {
                this.possibleValues = null;
            } else {
                this.possibleValues = new LinkedHashSet<String>();
                for (T value : values) {
                    this.possibleValues.add(value.toString());
                }
            }
            return this;
        }

        public NewParam setDefaultValue(@Nullable Object o) {
            this.defaultValue = o != null ? o.toString() : null;
            return this;
        }

        public NewParam setMaxValuesAllowed(@Nullable Integer maxValuesAllowed) {
            this.maxValuesAllowed = maxValuesAllowed;
            return this;
        }

        public NewParam setMaximumLength(@Nullable Integer maximumLength) {
            this.maximumLength = maximumLength;
            return this;
        }

        public NewParam setMinimumLength(@Nullable Integer minimumLength) {
            this.minimumLength = minimumLength;
            return this;
        }

        public NewParam setMaximumValue(@Nullable Integer maximumValue) {
            this.maximumValue = maximumValue;
            return this;
        }

        public String toString() {
            return this.key;
        }
    }

    @Immutable
    public static class Action {
        private static final Logger LOGGER = Loggers.get(Action.class);
        private final String key;
        private final String deprecatedKey;
        private final String path;
        private final String description;
        private final String since;
        private final String deprecatedSince;
        private final boolean post;
        private final boolean isInternal;
        private final RequestHandler handler;
        private final Map<String, Param> params;
        private final URL responseExample;
        private final List<Change> changelog;

        private Action(Controller controller, NewAction newAction) {
            this.key = newAction.key;
            this.deprecatedKey = newAction.deprecatedKey;
            this.path = String.format("%s/%s", controller.path(), this.key);
            this.description = newAction.description;
            this.since = newAction.since;
            this.deprecatedSince = newAction.deprecatedSince;
            this.post = newAction.post;
            this.isInternal = newAction.isInternal;
            this.responseExample = newAction.responseExample;
            this.handler = newAction.handler;
            this.changelog = newAction.changelog;
            Preconditions.checkState(this.handler != null, "RequestHandler is not set on action %s", this.path);
            Action.logWarningIf(this.description == null || this.description.isEmpty(), "Description is not set on action " + this.path);
            Action.logWarningIf(this.since == null || this.since.isEmpty(), "Since is not set on action " + this.path);
            Action.logWarningIf(!this.post && this.responseExample == null, "The response example is not set on action " + this.path);
            HashMap<String, Param> paramsBuilder = new HashMap<String, Param>();
            for (NewParam newParam : newAction.newParams.values()) {
                paramsBuilder.put(newParam.key, new Param(this, newParam));
            }
            this.params = Collections.unmodifiableMap(paramsBuilder);
        }

        private static void logWarningIf(boolean condition, String message) {
            if (condition) {
                LOGGER.warn(message);
            }
        }

        public String key() {
            return this.key;
        }

        public String deprecatedKey() {
            return this.deprecatedKey;
        }

        public String path() {
            return this.path;
        }

        @CheckForNull
        public String description() {
            return this.description;
        }

        @CheckForNull
        public String since() {
            return this.since;
        }

        @CheckForNull
        public String deprecatedSince() {
            return this.deprecatedSince;
        }

        public boolean isPost() {
            return this.post;
        }

        public List<Change> changelog() {
            return this.changelog;
        }

        public boolean isInternal() {
            return this.isInternal;
        }

        public RequestHandler handler() {
            return this.handler;
        }

        @CheckForNull
        public URL responseExample() {
            return this.responseExample;
        }

        @CheckForNull
        public String responseExampleAsString() {
            try {
                if (this.responseExample != null) {
                    return StringUtils.trim(IOUtils.toString(this.responseExample, StandardCharsets.UTF_8));
                }
                return null;
            }
            catch (IOException e) {
                throw new IllegalStateException("Fail to load " + this.responseExample, e);
            }
        }

        @CheckForNull
        public String responseExampleFormat() {
            if (this.responseExample != null) {
                return StringUtils.lowerCase(FilenameUtils.getExtension(this.responseExample.getFile()));
            }
            return null;
        }

        @CheckForNull
        public Param param(String key) {
            return this.params.get(key);
        }

        public Collection<Param> params() {
            return this.params.values();
        }

        public String toString() {
            return this.path;
        }
    }

    public static class NewAction {
        private final String key;
        private static final String PAGE_PARAM_DESCRIPTION = "1-based page number";
        private String deprecatedKey;
        private String description;
        private String since;
        private String deprecatedSince;
        private boolean post = false;
        private boolean isInternal = false;
        private RequestHandler handler;
        private Map<String, NewParam> newParams = new HashMap<String, NewParam>();
        private URL responseExample = null;
        private List<Change> changelog = new ArrayList<Change>();

        private NewAction(String key) {
            this.key = key;
        }

        public NewAction setDeprecatedKey(@Nullable String s) {
            this.deprecatedKey = s;
            return this;
        }

        public NewAction setDescription(@Nullable String description) {
            this.description = description;
            return this;
        }

        public NewAction setDescription(@Nullable String description, Object ... descriptionArgument) {
            this.description = description == null ? null : String.format(description, descriptionArgument);
            return this;
        }

        public NewAction setSince(@Nullable String s) {
            this.since = s;
            return this;
        }

        public NewAction setDeprecatedSince(@Nullable String deprecatedSince) {
            this.deprecatedSince = deprecatedSince;
            return this;
        }

        public NewAction setPost(boolean b) {
            this.post = b;
            return this;
        }

        public NewAction setInternal(boolean b) {
            this.isInternal = b;
            return this;
        }

        public NewAction setHandler(RequestHandler h) {
            this.handler = h;
            return this;
        }

        public NewAction setResponseExample(@Nullable URL url) {
            this.responseExample = url;
            return this;
        }

        public NewAction setChangelog(Change ... changes) {
            this.changelog = Arrays.stream(Objects.requireNonNull(changes)).filter(Objects::nonNull).collect(Collectors.toList());
            return this;
        }

        public NewParam createParam(String paramKey) {
            Preconditions.checkState(!this.newParams.containsKey(paramKey), "The parameter '%s' is defined multiple times in the action '%s'", paramKey, this.key);
            NewParam newParam = new NewParam(paramKey);
            this.newParams.put(paramKey, newParam);
            return newParam;
        }

        public NewAction addPagingParams(int defaultPageSize) {
            this.createParam("p").setDescription(PAGE_PARAM_DESCRIPTION).setExampleValue("42").setDefaultValue("1");
            this.createParam("ps").setDescription("Page size. Must be greater than 0.").setExampleValue("20").setDefaultValue(String.valueOf(defaultPageSize));
            return this;
        }

        public NewAction addPagingParams(int defaultPageSize, int maxPageSize) {
            this.createPageParam();
            this.createPageSize(defaultPageSize, maxPageSize);
            return this;
        }

        public NewParam createPageParam() {
            return this.createParam("p").setDescription(PAGE_PARAM_DESCRIPTION).setExampleValue("42").setDefaultValue("1");
        }

        public NewParam createPageSize(int defaultPageSize, int maxPageSize) {
            return this.createParam("ps").setDefaultValue(String.valueOf(defaultPageSize)).setMaximumValue(maxPageSize).setDescription("Page size. Must be greater than 0 and less or equal than " + maxPageSize).setExampleValue("20");
        }

        public NewAction addPagingParamsSince(int defaultPageSize, int maxPageSize, String version) {
            this.createParam("p").setDescription(PAGE_PARAM_DESCRIPTION).setExampleValue("42").setDefaultValue("1").setSince(version);
            this.createParam("ps").setDescription("Page size. Must be greater than 0 and less than " + maxPageSize).setDefaultValue(String.valueOf(defaultPageSize)).setMaximumValue(maxPageSize).setExampleValue("20").setSince(version);
            return this;
        }

        public NewAction addFieldsParam(Collection<?> possibleValues) {
            this.createFieldsParam(possibleValues);
            return this;
        }

        public NewParam createFieldsParam(Collection<?> possibleValues) {
            return this.createParam("f").setDescription("Comma-separated list of the fields to be returned in response. All the fields are returned by default.").setPossibleValues(possibleValues);
        }

        public NewAction addSearchQuery(String exampleValue, String ... pluralFields) {
            this.createSearchQuery(exampleValue, pluralFields);
            return this;
        }

        public NewParam createSearchQuery(String exampleValue, String ... pluralFields) {
            String actionDescription = String.format("Limit search to %s that contain the supplied string.", String.join((CharSequence)" or ", pluralFields));
            return this.createParam("q").setDescription(actionDescription).setExampleValue(exampleValue);
        }

        public <V> NewAction addSortParams(Collection<V> possibleValues, @Nullable V defaultValue, boolean defaultAscending) {
            this.createSortParams(possibleValues, defaultValue, defaultAscending);
            return this;
        }

        public <V> NewParam createSortParams(Collection<V> possibleValues, @Nullable V defaultValue, boolean defaultAscending) {
            this.createParam("asc").setDescription("Ascending sort").setBooleanPossibleValues().setDefaultValue(defaultAscending);
            return this.createParam("s").setDescription("Sort field").setDefaultValue(defaultValue).setPossibleValues(possibleValues);
        }

        public NewAction addSelectionModeParam() {
            this.createParam("selected").setDescription("Depending on the value, show only selected items (selected=selected), deselected items (selected=deselected), or all items with their selection status (selected=all).").setDefaultValue(SelectionMode.SELECTED.value()).setPossibleValues(SelectionMode.possibleValues());
            return this;
        }
    }

    @Immutable
    public static class Controller {
        private final String path;
        private final String description;
        private final String since;
        private final Map<String, Action> actions;

        private Controller(NewController newController) {
            Preconditions.checkState(!newController.actions.isEmpty(), "At least one action must be declared in the web service '%s'", newController.path);
            this.path = newController.path;
            this.description = newController.description;
            this.since = newController.since;
            HashMap<String, Action> mapBuilder = new HashMap<String, Action>();
            for (NewAction newAction : newController.actions.values()) {
                mapBuilder.put(newAction.key, new Action(this, newAction));
            }
            this.actions = Collections.unmodifiableMap(mapBuilder);
        }

        public String path() {
            return this.path;
        }

        @CheckForNull
        public String description() {
            return this.description;
        }

        @CheckForNull
        public String since() {
            return this.since;
        }

        @CheckForNull
        public Action action(String actionKey) {
            return this.actions.get(actionKey);
        }

        public Collection<Action> actions() {
            return this.actions.values();
        }

        public boolean isInternal() {
            for (Action action : this.actions()) {
                if (action.isInternal()) continue;
                return false;
            }
            return true;
        }
    }

    public static class NewController {
        private final Context context;
        private final String path;
        private String description;
        private String since;
        private final Map<String, NewAction> actions = new HashMap<String, NewAction>();

        private NewController(Context context, String path) {
            if (StringUtils.isBlank(path)) {
                throw new IllegalArgumentException("WS controller path must not be empty");
            }
            if (StringUtils.startsWith(path, "/") || StringUtils.endsWith(path, "/")) {
                throw new IllegalArgumentException("WS controller path must not start or end with slash: " + path);
            }
            this.context = context;
            this.path = path;
        }

        public void done() {
            this.context.register(this);
        }

        public NewController setDescription(@Nullable String s) {
            this.description = s;
            return this;
        }

        public NewController setSince(@Nullable String s) {
            this.since = s;
            return this;
        }

        public NewAction createAction(String actionKey) {
            if (this.actions.containsKey(actionKey)) {
                throw new IllegalStateException(String.format("The action '%s' is defined multiple times in the web service '%s'", actionKey, this.path));
            }
            NewAction action = new NewAction(actionKey);
            this.actions.put(actionKey, action);
            return action;
        }
    }

    public static class Context {
        private final Map<String, Controller> controllers = new HashMap<String, Controller>();

        public NewController createController(String path) {
            return new NewController(this, path);
        }

        private void register(NewController newController) {
            if (this.controllers.containsKey(newController.path)) {
                throw new IllegalStateException(String.format("The web service '%s' is defined multiple times", newController.path));
            }
            this.controllers.put(newController.path, new Controller(newController));
        }

        @CheckForNull
        public Controller controller(String key) {
            return this.controllers.get(key);
        }

        public List<Controller> controllers() {
            return Collections.unmodifiableList(new ArrayList<Controller>(this.controllers.values()));
        }
    }
}

