/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.internal.apachecommons.io.ByteOrderMark;
import org.sonar.api.internal.apachecommons.io.input.BOMInputStream;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rule.Severity;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.ServerSide;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.api.server.rule.RuleParamType;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.check.Cardinality;
import org.sonarsource.api.sonarlint.SonarLintSide;

@ServerSide
@ComputeEngineSide
@SonarLintSide
public class RulesDefinitionXmlLoader {
    private static final String ELEMENT_RULES = "rules";
    private static final String ELEMENT_RULE = "rule";
    private static final String ELEMENT_PARAM = "param";

    public void load(RulesDefinition.NewRepository repo, InputStream input, String encoding) {
        this.load(repo, input, Charset.forName(encoding));
    }

    public void load(RulesDefinition.NewRepository repo, InputStream input, Charset charset) {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new BOMInputStream(input, ByteOrderMark.UTF_8, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_32LE, ByteOrderMark.UTF_32BE), charset);){
            this.load(repo, reader);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error while reading XML rules definition for repository " + repo.key(), e);
        }
    }

    public void load(RulesDefinition.NewRepository repo, Reader inputReader) {
        XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
        xmlFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        xmlFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        try {
            XMLEventReader reader = xmlFactory.createXMLEventReader(inputReader);
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (!event.isStartElement() || !event.asStartElement().getName().getLocalPart().equals(ELEMENT_RULES)) continue;
                RulesDefinitionXmlLoader.parseRules(repo, reader);
            }
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException("XML is not valid", e);
        }
    }

    private static void parseRules(RulesDefinition.NewRepository repo, XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            StartElement element;
            String elementName;
            XMLEvent event = reader.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().getLocalPart().equals(ELEMENT_RULES)) {
                return;
            }
            if (!event.isStartElement() || !ELEMENT_RULE.equals(elementName = (element = event.asStartElement()).getName().getLocalPart())) continue;
            RulesDefinitionXmlLoader.processRule(repo, element, reader);
        }
    }

    private static void processRule(RulesDefinition.NewRepository repo, StartElement ruleElement, XMLEventReader reader) throws XMLStreamException {
        Attribute priorityAttribute;
        String key = null;
        String name = null;
        String description = null;
        String descriptionFormat = DescriptionFormat.HTML.name();
        String internalKey = null;
        String severity = Severity.defaultSeverity();
        String type = null;
        RuleStatus status = RuleStatus.defaultStatus();
        boolean template = false;
        String gapDescription = null;
        String debtRemediationFunction = null;
        String debtRemediationFunctionGapMultiplier = null;
        String debtRemediationFunctionBaseEffort = null;
        ArrayList<ParamStruct> params = new ArrayList<ParamStruct>();
        ArrayList<String> tags = new ArrayList<String>();
        Attribute keyAttribute = ruleElement.getAttributeByName(new QName("key"));
        if (keyAttribute != null && StringUtils.isNotBlank(keyAttribute.getValue())) {
            key = StringUtils.trim(keyAttribute.getValue());
        }
        if ((priorityAttribute = ruleElement.getAttributeByName(new QName("priority"))) != null && StringUtils.isNotBlank(priorityAttribute.getValue())) {
            severity = StringUtils.trim(priorityAttribute.getValue());
        }
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().getLocalPart().equals(ELEMENT_RULE)) {
                RulesDefinitionXmlLoader.buildRule(repo, key, name, description, descriptionFormat, internalKey, severity, type, status, template, gapDescription, debtRemediationFunction, debtRemediationFunctionGapMultiplier, debtRemediationFunctionBaseEffort, params, tags);
                return;
            }
            if (!event.isStartElement()) continue;
            StartElement element = event.asStartElement();
            String elementName = element.getName().getLocalPart();
            if ("name".equalsIgnoreCase(elementName)) {
                name = StringUtils.trim(reader.getElementText());
                continue;
            }
            if ("type".equalsIgnoreCase(elementName)) {
                type = StringUtils.trim(reader.getElementText());
                continue;
            }
            if ("description".equalsIgnoreCase(elementName)) {
                description = StringUtils.trim(reader.getElementText());
                continue;
            }
            if ("descriptionFormat".equalsIgnoreCase(elementName)) {
                descriptionFormat = StringUtils.trim(reader.getElementText());
                continue;
            }
            if ("key".equalsIgnoreCase(elementName)) {
                key = StringUtils.trim(reader.getElementText());
                continue;
            }
            if ("configKey".equalsIgnoreCase(elementName)) {
                internalKey = StringUtils.trim(reader.getElementText());
                continue;
            }
            if ("internalKey".equalsIgnoreCase(elementName)) {
                internalKey = StringUtils.trim(reader.getElementText());
                continue;
            }
            if ("priority".equalsIgnoreCase(elementName) || "severity".equalsIgnoreCase(elementName)) {
                severity = StringUtils.trim(reader.getElementText());
                continue;
            }
            if ("cardinality".equalsIgnoreCase(elementName)) {
                template = Cardinality.MULTIPLE == Cardinality.valueOf(StringUtils.trim(reader.getElementText()));
                continue;
            }
            if ("gapDescription".equalsIgnoreCase(elementName) || "effortToFixDescription".equalsIgnoreCase(elementName)) {
                gapDescription = StringUtils.trim(reader.getElementText());
                continue;
            }
            if ("remediationFunction".equalsIgnoreCase(elementName) || "debtRemediationFunction".equalsIgnoreCase(elementName)) {
                debtRemediationFunction = StringUtils.trim(reader.getElementText());
                continue;
            }
            if ("remediationFunctionBaseEffort".equalsIgnoreCase(elementName) || "debtRemediationFunctionOffset".equalsIgnoreCase(elementName)) {
                debtRemediationFunctionGapMultiplier = StringUtils.trim(reader.getElementText());
                continue;
            }
            if ("remediationFunctionGapMultiplier".equalsIgnoreCase(elementName) || "debtRemediationFunctionCoefficient".equalsIgnoreCase(elementName)) {
                debtRemediationFunctionBaseEffort = StringUtils.trim(reader.getElementText());
                continue;
            }
            if ("status".equalsIgnoreCase(elementName)) {
                String s = StringUtils.trim(reader.getElementText());
                if (s == null) continue;
                status = RuleStatus.valueOf(s);
                continue;
            }
            if (ELEMENT_PARAM.equalsIgnoreCase(elementName)) {
                params.add(RulesDefinitionXmlLoader.processParameter(element, reader));
                continue;
            }
            if (!"tag".equalsIgnoreCase(elementName)) continue;
            tags.add(StringUtils.trim(reader.getElementText()));
        }
    }

    private static void buildRule(RulesDefinition.NewRepository repo, String key, String name, @Nullable String description, String descriptionFormat, @Nullable String internalKey, String severity, @Nullable String type, RuleStatus status, boolean template, @Nullable String gapDescription, @Nullable String debtRemediationFunction, @Nullable String debtRemediationFunctionGapMultiplier, @Nullable String debtRemediationFunctionBaseEffort, List<ParamStruct> params, List<String> tags) {
        try {
            RulesDefinition.NewRule rule = repo.createRule(key).setSeverity(severity).setName(name).setInternalKey(internalKey).setTags(tags.toArray(new String[tags.size()])).setTemplate(template).setStatus(status).setGapDescription(gapDescription);
            if (type != null) {
                rule.setType(RuleType.valueOf(type));
            }
            RulesDefinitionXmlLoader.fillDescription(rule, descriptionFormat, description);
            RulesDefinitionXmlLoader.fillRemediationFunction(rule, debtRemediationFunction, debtRemediationFunctionGapMultiplier, debtRemediationFunctionBaseEffort);
            RulesDefinitionXmlLoader.fillParams(rule, params);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Fail to load the rule with key [%s:%s]", repo.key(), key), e);
        }
    }

    private static void fillDescription(RulesDefinition.NewRule rule, String descriptionFormat, @Nullable String description) {
        if (StringUtils.isNotBlank(description)) {
            switch (DescriptionFormat.valueOf(descriptionFormat)) {
                case HTML: {
                    rule.setHtmlDescription(description);
                    break;
                }
                case MARKDOWN: {
                    rule.setMarkdownDescription(description);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Value of descriptionFormat is not supported: " + descriptionFormat);
                }
            }
        }
    }

    private static void fillRemediationFunction(RulesDefinition.NewRule rule, @Nullable String debtRemediationFunction, @Nullable String functionOffset, @Nullable String functionCoeff) {
        if (StringUtils.isNotBlank(debtRemediationFunction)) {
            DebtRemediationFunction.Type functionType = DebtRemediationFunction.Type.valueOf(debtRemediationFunction);
            rule.setDebtRemediationFunction(rule.debtRemediationFunctions().create(functionType, functionCoeff, functionOffset));
        }
    }

    private static void fillParams(RulesDefinition.NewRule rule, List<ParamStruct> params) {
        for (ParamStruct param : params) {
            rule.createParam(param.key).setDefaultValue(param.defaultValue).setType(param.type).setDescription(param.description);
        }
    }

    private static ParamStruct processParameter(StartElement paramElement, XMLEventReader reader) throws XMLStreamException {
        Attribute typeAttribute;
        ParamStruct param = new ParamStruct();
        Attribute keyAttribute = paramElement.getAttributeByName(new QName("key"));
        if (keyAttribute != null && StringUtils.isNotBlank(keyAttribute.getValue())) {
            param.key = StringUtils.trim(keyAttribute.getValue());
        }
        if ((typeAttribute = paramElement.getAttributeByName(new QName("type"))) != null && StringUtils.isNotBlank(typeAttribute.getValue())) {
            param.type = RuleParamType.parse(StringUtils.trim(typeAttribute.getValue()));
        }
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().getLocalPart().equals(ELEMENT_PARAM)) {
                return param;
            }
            if (!event.isStartElement()) continue;
            StartElement element = event.asStartElement();
            String elementName = element.getName().getLocalPart();
            if ("key".equalsIgnoreCase(elementName)) {
                param.key = StringUtils.trim(reader.getElementText());
                continue;
            }
            if ("description".equalsIgnoreCase(elementName)) {
                param.description = StringUtils.trim(reader.getElementText());
                continue;
            }
            if ("type".equalsIgnoreCase(elementName)) {
                param.type = RuleParamType.parse(StringUtils.trim(reader.getElementText()));
                continue;
            }
            if (!"defaultValue".equalsIgnoreCase(elementName)) continue;
            param.defaultValue = StringUtils.trim(reader.getElementText());
        }
        return param;
    }

    private static class ParamStruct {
        String key;
        String description;
        String defaultValue;
        RuleParamType type = RuleParamType.STRING;

        private ParamStruct() {
        }
    }

    private static enum DescriptionFormat {
        HTML,
        MARKDOWN;

    }
}

