/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.phpunit.xml;

import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public final class TestCase {
    private String className;
    private String name;
    private String error;
    private String failure;
    private String skipped;

    public TestCase(String className, String name, String error, String failure, String skipped) {
        this.className = className;
        this.name = name;
        this.error = error;
        this.failure = failure;
        this.skipped = skipped;
    }

    @VisibleForTesting
    public TestCase(Status status) {
        if (status == Status.ERROR) {
            this.error = status.toString();
        }
        if (status == Status.FAILURE) {
            this.failure = status.toString();
        }
        if (status == Status.SKIPPED) {
            this.skipped = Status.SKIPPED.toString();
        }
    }

    public Status getStatus() {
        if (StringUtils.isNotBlank(this.error)) {
            return Status.ERROR;
        }
        if (StringUtils.isNotBlank(this.failure)) {
            return Status.FAILURE;
        }
        if (this.skipped != null) {
            return Status.SKIPPED;
        }
        return Status.OK;
    }

    public String toString() {
        return new ToStringBuilder(this).append("className", this.className).append("name", this.name).append("status", (Object)this.getStatus()).toString();
    }

    String fullName() {
        if (this.className != null) {
            return this.className + "." + this.name;
        }
        return this.name;
    }

    public static enum Status {
        OK,
        SKIPPED,
        FAILURE,
        ERROR;

    }
}

