/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.phpunit;

import java.io.Serializable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.php.phpunit.TestResultImporter;
import org.sonar.plugins.php.phpunit.xml.TestCase;

public class TestFileReport {
    private static final Logger LOGGER = Loggers.get(TestResultImporter.class);
    private int errors = 0;
    private int failures = 0;
    private String file;
    private int skipped = 0;
    private int tests = 0;
    private double testDuration = 0.0;

    public TestFileReport(String file, double testDuration) {
        this.file = file;
        this.testDuration = testDuration;
    }

    public void saveTestMeasures(SensorContext context) {
        InputFile unitTestFile = this.getUnitTestInputFile(context.fileSystem());
        if (unitTestFile != null) {
            context.newMeasure().on((InputComponent)unitTestFile).withValue((Serializable)Integer.valueOf(this.skipped)).forMetric((Metric)CoreMetrics.SKIPPED_TESTS).save();
            context.newMeasure().on((InputComponent)unitTestFile).withValue((Serializable)Long.valueOf((long)this.testDurationMilliseconds())).forMetric((Metric)CoreMetrics.TEST_EXECUTION_TIME).save();
            context.newMeasure().on((InputComponent)unitTestFile).withValue((Serializable)Integer.valueOf((int)this.liveTests())).forMetric((Metric)CoreMetrics.TESTS).save();
            context.newMeasure().on((InputComponent)unitTestFile).withValue((Serializable)Integer.valueOf(this.errors)).forMetric((Metric)CoreMetrics.TEST_ERRORS).save();
            context.newMeasure().on((InputComponent)unitTestFile).withValue((Serializable)Integer.valueOf(this.failures)).forMetric((Metric)CoreMetrics.TEST_FAILURES).save();
        } else {
            LOGGER.debug("Following file is not located in the test folder specified in the Sonar configuration: " + this.file + ". The test results won't be reported in Sonar.");
        }
    }

    private double liveTests() {
        return (double)this.tests - (double)this.skipped;
    }

    private double testDurationMilliseconds() {
        return this.testDuration * 1000.0;
    }

    private InputFile getUnitTestInputFile(FileSystem fileSystem) {
        FilePredicates predicates = fileSystem.predicates();
        return fileSystem.inputFile(predicates.and(new FilePredicate[]{predicates.hasPath(this.file), predicates.hasType(InputFile.Type.TEST), predicates.hasLanguage("php")}));
    }

    public void addTestCase(TestCase testCase) {
        if (testCase.getStatus() == TestCase.Status.SKIPPED) {
            ++this.skipped;
        } else if (testCase.getStatus() == TestCase.Status.FAILURE) {
            ++this.failures;
        } else if (testCase.getStatus() == TestCase.Status.ERROR) {
            ++this.errors;
        }
        ++this.tests;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestFileReport that = (TestFileReport)o;
        return new EqualsBuilder().append(this.errors, that.errors).append(this.failures, that.failures).append(this.skipped, that.skipped).append(this.tests, that.tests).append(this.testDuration, that.testDuration).append(this.file, that.file).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.errors).append(this.failures).append(this.file).append(this.skipped).append(this.tests).append(this.testDuration).toHashCode();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this);
        builder.append("errors", this.errors);
        builder.append("failures", this.failures);
        builder.append("file", this.file);
        builder.append("skipped", this.skipped);
        builder.append("tests", this.tests);
        builder.append("testDuration", this.testDuration);
        return builder.toString();
    }
}

