/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.phpunit;

import java.io.File;
import java.util.Optional;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.php.phpunit.ReportImporter;

public abstract class SingleFileReportImporter
implements ReportImporter {
    private static final Logger LOG = Loggers.get(SingleFileReportImporter.class);
    private String reportPathKey;
    private String msg;

    protected SingleFileReportImporter(String reportPathKey, String msg) {
        this.reportPathKey = reportPathKey;
        this.msg = msg;
    }

    @Override
    public final void importReport(SensorContext context) {
        Optional reportPath = context.config().get(this.reportPathKey);
        if (reportPath.isPresent()) {
            this.importReport((String)reportPath.get(), this.msg, context);
        } else {
            LOG.info("No PHPUnit {} report provided (see '{}' property)", (Object)this.msg, (Object)this.reportPathKey);
        }
    }

    final void importReport(String reportPath, String msg, SensorContext context) {
        Optional<File> maybeFile = this.getIOFile(reportPath, context);
        maybeFile.ifPresent(file -> {
            LOG.info("Analyzing PHPUnit {} report: {}", (Object)msg, (Object)reportPath);
            this.importReport((File)file, context);
        });
    }

    protected abstract void importReport(File var1, SensorContext var2);

    private Optional<File> getIOFile(String path, SensorContext context) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(context.fileSystem().baseDir(), path);
        }
        if (file.exists()) {
            return Optional.of(file);
        }
        LOG.warn("PHPUnit xml {} report not found: {}", (Object)this.msg, (Object)path);
        return Optional.empty();
    }
}

