/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.phpunit;

import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.php.phpunit.ReportImporter;
import org.sonar.plugins.php.phpunit.SingleFileReportImporter;

public class MultiPathImporter
implements ReportImporter {
    private static final Logger LOG = Loggers.get(MultiPathImporter.class);
    private final SingleFileReportImporter importer;
    private final String pathsKey;
    private final String msg;

    public MultiPathImporter(SingleFileReportImporter importer, String pathsKey, String msg) {
        this.importer = importer;
        this.pathsKey = pathsKey;
        this.msg = msg;
    }

    @Override
    public void importReport(SensorContext context) {
        String[] paths = context.config().getStringArray(this.pathsKey);
        if (paths.length == 0) {
            LOG.info("No PHPUnit {} reports provided (see '{}' property)", (Object)this.msg, (Object)this.pathsKey);
            return;
        }
        for (String path : paths) {
            if (path.isEmpty()) continue;
            this.importer.importReport(path, this.msg, context);
        }
    }
}

