/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.phpunit;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.plugins.php.phpunit.xml.TestCase;
import org.sonar.plugins.php.phpunit.xml.TestSuite;
import org.sonar.plugins.php.phpunit.xml.TestSuites;

public class JUnitLogParserForPhpUnit {
    public TestSuites parse(File report) {
        try {
            return JUnitLogParserForPhpUnit.processRoot(report, JUnitLogParserForPhpUnit.inputFactory());
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException("Can't read PhpUnit report : " + report.getAbsolutePath(), e);
        }
    }

    public static SMInputFactory inputFactory() {
        XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
        xmlFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
        xmlFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        xmlFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        return new SMInputFactory(xmlFactory);
    }

    private static TestSuites processRoot(File file, SMInputFactory inputFactory) throws XMLStreamException {
        SMHierarchicCursor rootCursor = inputFactory.rootElementCursor(file);
        rootCursor.advance();
        if (!"testsuites".equals(rootCursor.getLocalName())) {
            throw new XMLStreamException("Report should start with <testsuites>");
        }
        SMInputCursor childCursor = rootCursor.childElementCursor("testsuite");
        ArrayList<TestSuite> testSuites = new ArrayList<TestSuite>();
        while (childCursor.getNext() != null) {
            testSuites.add(JUnitLogParserForPhpUnit.processTestSuite(childCursor));
        }
        return new TestSuites(testSuites);
    }

    private static TestSuite processTestSuite(SMInputCursor cursor) throws XMLStreamException {
        String name = cursor.getAttrValue("name");
        String file = cursor.getAttrValue("file");
        double time = Double.parseDouble(cursor.getAttrValue("time"));
        ArrayList<TestCase> testCases = new ArrayList<TestCase>();
        ArrayList<TestSuite> nestedSuites = new ArrayList<TestSuite>();
        SMInputCursor childCursor = cursor.childCursor();
        while (childCursor.getNext() != null) {
            String childName = childCursor.getLocalName();
            if ("testsuite".equals(childName)) {
                nestedSuites.add(JUnitLogParserForPhpUnit.processTestSuite(childCursor));
                continue;
            }
            if (!"testcase".equals(childName)) continue;
            testCases.add(JUnitLogParserForPhpUnit.processTestCase(childCursor));
        }
        TestSuite testSuite = new TestSuite(name, file, time, testCases);
        nestedSuites.forEach(testSuite::addNested);
        return testSuite;
    }

    private static TestCase processTestCase(SMInputCursor cursor) throws XMLStreamException {
        String className = cursor.getAttrValue("class");
        String name = cursor.getAttrValue("name");
        SMInputCursor childCursor = cursor.childCursor();
        HashMap<String, String> childValues = new HashMap<String, String>();
        while (childCursor.getNext() != null) {
            if (childCursor.getLocalName() == null) continue;
            childValues.put(childCursor.getLocalName(), childCursor.collectDescendantText(false));
        }
        return new TestCase(className, name, (String)childValues.get("error"), (String)childValues.get("failure"), (String)childValues.get("skipped"));
    }
}

