/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.phpunit;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.xml.stream.XMLStreamException;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.api.measures.Metric;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.php.phpunit.JUnitLogParserForPhpUnit;
import org.sonar.plugins.php.phpunit.SingleFileReportImporter;
import org.sonar.plugins.php.phpunit.xml.CoverageNode;
import org.sonar.plugins.php.phpunit.xml.FileNode;
import org.sonar.plugins.php.phpunit.xml.LineNode;
import org.sonar.plugins.php.phpunit.xml.PackageNode;
import org.sonar.plugins.php.phpunit.xml.ProjectNode;

public class CoverageResultImporter
extends SingleFileReportImporter {
    private static final Logger LOG = Loggers.get(CoverageResultImporter.class);
    private static final String WRONG_LINE_EXCEPTION_MESSAGE = "Line with number %s doesn't belong to file %s";
    protected Metric<Integer> linesToCoverMetric;
    protected Metric<Integer> uncoveredLinesMetric;

    public CoverageResultImporter(String reportPathKey, String msg, Metric<Integer> linesToCoverMetric, Metric<Integer> uncoveredLinesMetric) {
        super(reportPathKey, msg);
        this.linesToCoverMetric = linesToCoverMetric;
        this.uncoveredLinesMetric = uncoveredLinesMetric;
    }

    @Override
    protected void importReport(File coverageReportFile, SensorContext context) {
        LOG.debug("Parsing file: " + coverageReportFile.getAbsolutePath());
        this.parseFile(coverageReportFile, context);
    }

    private void parseFile(File coverageReportFile, SensorContext context) {
        CoverageNode coverage = CoverageResultImporter.getCoverage(coverageReportFile);
        ArrayList<String> unresolvedPaths = new ArrayList<String>();
        List<ProjectNode> projects = coverage.getProjects();
        if (projects != null && !projects.isEmpty()) {
            ProjectNode projectNode = projects.get(0);
            this.parseFileNodes(projectNode.getFiles(), unresolvedPaths, context);
            this.parsePackagesNodes(projectNode.getPackages(), unresolvedPaths, context);
        }
        if (!unresolvedPaths.isEmpty()) {
            LOG.warn(String.format("Could not resolve %d file paths in %s, first unresolved path: %s", unresolvedPaths.size(), coverageReportFile.getName(), unresolvedPaths.get(0)));
        }
    }

    private void parsePackagesNodes(@Nullable List<PackageNode> packages, List<String> unresolvedPaths, SensorContext context) {
        if (packages != null) {
            for (PackageNode packageNode : packages) {
                this.parseFileNodes(packageNode.getFiles(), unresolvedPaths, context);
            }
        }
    }

    private void parseFileNodes(@Nullable List<FileNode> fileNodes, List<String> unresolvedPaths, SensorContext context) {
        if (fileNodes != null) {
            for (FileNode file : fileNodes) {
                this.saveCoverageMeasure(file, unresolvedPaths, context);
            }
        }
    }

    protected void saveCoverageMeasure(FileNode fileNode, List<String> unresolvedPaths, SensorContext context) {
        FileSystem fileSystem = context.fileSystem();
        String path = fileNode.getName();
        InputFile inputFile = fileSystem.inputFile(fileSystem.predicates().hasAbsolutePath(path));
        if (inputFile != null) {
            CoverageResultImporter.saveCoverageLineHitsData(fileNode, inputFile, context);
        } else {
            unresolvedPaths.add(path);
        }
    }

    private static void saveCoverageLineHitsData(FileNode fileNode, InputFile inputFile, SensorContext context) {
        NewCoverage newCoverage = context.newCoverage().onFile(inputFile);
        if (fileNode.getLines() != null) {
            for (LineNode line : fileNode.getLines()) {
                int lineNum = line.getNum();
                if (lineNum > 0 && lineNum <= inputFile.lines()) {
                    newCoverage.lineHits(line.getNum(), line.getCount());
                    continue;
                }
                LOG.warn(String.format(WRONG_LINE_EXCEPTION_MESSAGE, lineNum, inputFile.filename()));
            }
        }
        newCoverage.save();
    }

    private static CoverageNode getCoverage(File coverageReportFile) {
        SMInputFactory inputFactory = JUnitLogParserForPhpUnit.inputFactory();
        try {
            SMHierarchicCursor rootCursor = inputFactory.rootElementCursor(coverageReportFile);
            rootCursor.advance();
            if (!"coverage".equals(rootCursor.getLocalName())) {
                throw new XMLStreamException("Report should start with <coverage>");
            }
            return CoverageResultImporter.parseCoverageNode(rootCursor);
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException("Can't read phpUnit report: " + coverageReportFile.getName(), e);
        }
    }

    private static CoverageNode parseCoverageNode(SMHierarchicCursor cursor) throws XMLStreamException {
        CoverageNode result = new CoverageNode();
        SMInputCursor childCursor = cursor.childElementCursor("project");
        while (childCursor.getNext() != null) {
            result.getProjects().add(CoverageResultImporter.parseProjectNode(childCursor));
        }
        return result;
    }

    private static ProjectNode parseProjectNode(SMInputCursor cursor) throws XMLStreamException {
        ProjectNode result = new ProjectNode();
        result.setName(cursor.getAttrValue("name"));
        SMInputCursor childCursor = cursor.childElementCursor();
        while (childCursor.getNext() != null) {
            if ("package".equals(childCursor.getLocalName())) {
                result.getPackages().add(CoverageResultImporter.parsePackageNode(childCursor));
                continue;
            }
            if (!"file".equals(childCursor.getLocalName())) continue;
            result.getFiles().add(CoverageResultImporter.parseFileNode(childCursor));
        }
        return result;
    }

    private static PackageNode parsePackageNode(SMInputCursor cursor) throws XMLStreamException {
        PackageNode result = new PackageNode();
        result.setName(cursor.getAttrValue("name"));
        SMInputCursor childCursor = cursor.childElementCursor("file");
        while (childCursor.getNext() != null) {
            result.getFiles().add(CoverageResultImporter.parseFileNode(childCursor));
        }
        return result;
    }

    private static FileNode parseFileNode(SMInputCursor cursor) throws XMLStreamException {
        FileNode result = new FileNode();
        result.setName(cursor.getAttrValue("name"));
        SMInputCursor childCursor = cursor.childElementCursor("line");
        while (childCursor.getNext() != null) {
            result.getLines().add(CoverageResultImporter.parseLineNode(childCursor));
        }
        return result;
    }

    private static LineNode parseLineNode(SMInputCursor cursor) throws XMLStreamException {
        int count = CoverageResultImporter.attributeIntValue(cursor, "count");
        int num = CoverageResultImporter.attributeIntValue(cursor, "num");
        String type = cursor.getAttrValue("type");
        return new LineNode(count, num, type);
    }

    private static int attributeIntValue(SMInputCursor cursor, String name) throws XMLStreamException {
        return Integer.parseInt(cursor.getAttrValue(name));
    }
}

