/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.phpunit;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;
import org.sonar.plugins.php.phpunit.CoverageResultImporter;
import org.sonar.plugins.php.phpunit.MultiPathImporter;
import org.sonar.plugins.php.phpunit.ReportImporter;

public class CompatibilityImportersFactory {
    public static final String DEPRECATION_WARNING_TEMPLATE = "%s is deprecated as of SonarQube 6.2. Please consider using sonar.php.coverage.reportPaths";
    public static final String SKIPPED_WARNING_TEMPLATE = "Ignoring %s since you are already using sonar.php.coverage.reportPaths. Please remove %<s";
    private static final List<String> LEGACY_PATH_KEYS = Arrays.asList("sonar.php.coverage.reportPath", "sonar.php.coverage.itReportPath", "sonar.php.coverage.overallReportPath");
    private final SensorContext context;

    public CompatibilityImportersFactory(SensorContext context) {
        this.context = context;
    }

    public ReportImporter createCoverageImporter() {
        if (LEGACY_PATH_KEYS.stream().anyMatch(this::isPropertyUsed) && !this.multiPathCoverageUsed()) {
            return CompatibilityImportersFactory.createLegacyImporters();
        }
        return CompatibilityImportersFactory.createMultiCoverageImporter();
    }

    private boolean multiPathCoverageUsed() {
        return this.context.config().getStringArray("sonar.php.coverage.reportPaths").length > 0;
    }

    private static ReportImporter createMultiCoverageImporter() {
        String msg = "coverage";
        String propertyKey = "sonar.php.coverage.reportPaths";
        CoverageResultImporter singleReportImporter = new CoverageResultImporter(propertyKey, msg, (Metric<Integer>)CoreMetrics.LINES_TO_COVER, (Metric<Integer>)CoreMetrics.UNCOVERED_LINES);
        return new MultiPathImporter(singleReportImporter, propertyKey, msg);
    }

    private static ReportImporter createLegacyImporters() {
        return new CoverageResultImporter("sonar.php.coverage.reportPath", "unit test coverage", (Metric<Integer>)CoreMetrics.LINES_TO_COVER, (Metric<Integer>)CoreMetrics.UNCOVERED_LINES);
    }

    public List<String> deprecationWarnings() {
        if (this.multiPathCoverageUsed()) {
            return this.printWarningForUsedLegacyPaths(SKIPPED_WARNING_TEMPLATE);
        }
        return this.printWarningForUsedLegacyPaths(DEPRECATION_WARNING_TEMPLATE);
    }

    private List<String> printWarningForUsedLegacyPaths(String warningTemplate) {
        return LEGACY_PATH_KEYS.stream().filter(this::isPropertyUsed).map(pathKey -> String.format(warningTemplate, pathKey)).collect(Collectors.toList());
    }

    private boolean isPropertyUsed(String legacyPathKey) {
        return this.context.config().get(legacyPathKey).isPresent();
    }
}

