/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.api.symbols;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.util.LinkedList;
import java.util.List;
import org.sonar.php.tree.symbols.Scope;
import org.sonar.plugins.php.api.tree.expression.IdentifierTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;

@Beta
public class Symbol {
    private final String name;
    private final IdentifierTree declaration;
    private Kind kind;
    private Scope scope;
    private List<SyntaxToken> usages = new LinkedList<SyntaxToken>();
    private List<SyntaxToken> modifiers = new LinkedList<SyntaxToken>();

    public Symbol(IdentifierTree declaration, Kind kind, Scope scope) {
        this.declaration = declaration;
        this.name = declaration.text();
        this.kind = kind;
        this.scope = scope;
    }

    public ImmutableList<SyntaxToken> modifiers() {
        return ImmutableList.copyOf(this.modifiers);
    }

    public boolean hasModifier(String modifier) {
        for (SyntaxToken syntaxToken : this.modifiers) {
            if (!syntaxToken.text().equalsIgnoreCase(modifier)) continue;
            return true;
        }
        return false;
    }

    public void addModifiers(List<SyntaxToken> modifiers) {
        this.modifiers.addAll(modifiers);
    }

    public void addUsage(SyntaxToken usage) {
        this.usages.add(usage);
    }

    public void addUsage(IdentifierTree usage) {
        this.usages.add(usage.token());
    }

    public List<SyntaxToken> usages() {
        return this.usages;
    }

    public Scope scope() {
        return this.scope;
    }

    public String name() {
        return this.name;
    }

    public IdentifierTree declaration() {
        return this.declaration;
    }

    public boolean is(Kind kind) {
        return kind.equals((Object)this.kind);
    }

    public boolean called(String name) {
        return name.equalsIgnoreCase(this.name);
    }

    public Kind kind() {
        return this.kind;
    }

    public String toString() {
        return "Symbol{name='" + this.name + '\'' + ", kind=" + (Object)((Object)this.kind) + ", scope=" + this.scope + '}';
    }

    public static enum Kind {
        VARIABLE("variable"),
        FUNCTION("function"),
        PARAMETER("parameter"),
        CLASS("class"),
        FIELD("field");

        private final String value;

        private Kind(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

