/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.api;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Configuration;
import org.sonar.api.resources.AbstractLanguage;

public final class Php
extends AbstractLanguage {
    public static final String NAME = "PHP";
    public static final String KEY = "php";
    public static final String DEFAULT_FILE_SUFFIXES = "php,php3,php4,php5,phtml,inc";
    private Configuration settings;

    public Php(Configuration settings) {
        super(KEY, NAME);
        this.settings = settings;
    }

    public String[] getFileSuffixes() {
        String[] suffixes = Php.filterEmptyStrings(this.settings.getStringArray("sonar.php.file.suffixes"));
        if (suffixes.length == 0) {
            suffixes = StringUtils.split(DEFAULT_FILE_SUFFIXES, ",");
        }
        return suffixes;
    }

    private static String[] filterEmptyStrings(String[] stringArray) {
        ArrayList<String> nonEmptyStrings = Lists.newArrayList();
        for (String string : stringArray) {
            if (!StringUtils.isNotBlank(string.trim())) continue;
            nonEmptyStrings.add(string.trim());
        }
        return nonEmptyStrings.toArray(new String[nonEmptyStrings.size()]);
    }

    public boolean hasValidSuffixes(String fileName) {
        String pathLowerCase = StringUtils.lowerCase(fileName);
        for (String suffix : this.getFileSuffixes()) {
            if (!pathLowerCase.endsWith("." + StringUtils.lowerCase(suffix))) continue;
            return true;
        }
        return false;
    }
}

