/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php;

import org.sonar.api.Plugin;
import org.sonar.api.SonarProduct;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.plugins.php.DrupalProfileDefinition;
import org.sonar.plugins.php.PHPProfileDefinition;
import org.sonar.plugins.php.PHPRulesDefinition;
import org.sonar.plugins.php.PHPSensor;
import org.sonar.plugins.php.PSR2ProfileDefinition;
import org.sonar.plugins.php.PhpIniSensor;
import org.sonar.plugins.php.api.Php;

public class PhpPlugin
implements Plugin {
    public static final String FILE_SUFFIXES_KEY = "sonar.php.file.suffixes";
    public static final String PHPUNIT_OVERALL_COVERAGE_REPORT_PATH_KEY = "sonar.php.coverage.overallReportPath";
    public static final String PHPUNIT_IT_COVERAGE_REPORT_PATH_KEY = "sonar.php.coverage.itReportPath";
    public static final String PHPUNIT_COVERAGE_REPORT_PATH_KEY = "sonar.php.coverage.reportPath";
    public static final String PHPUNIT_COVERAGE_REPORT_PATHS_KEY = "sonar.php.coverage.reportPaths";
    public static final String PHPUNIT_TESTS_REPORT_PATH_KEY = "sonar.php.tests.reportPath";
    public static final String PHP_CATEGORY = "PHP";
    public static final String GENERAL_SUBCATEGORY = "General";
    public static final String PHPUNIT_SUBCATEGORY = "PHPUnit";
    private static final String DEPRECATION_MESSAGE = "DEPRECATED: use sonar.php.coverage.reportPaths. ";
    private static final String REPORT_PATH_DESCRIPTION_TEMPLATE = "%sPath to the PHPUnit %s report file. The path may be either absolute or relative to the project base directory.";

    public void define(Plugin.Context context) {
        context.addExtensions(Php.class, PHPSensor.class, new Object[]{PhpIniSensor.class, PHPRulesDefinition.class, PHPProfileDefinition.class, PSR2ProfileDefinition.class, DrupalProfileDefinition.class, PropertyDefinition.builder((String)FILE_SUFFIXES_KEY).defaultValue("php,php3,php4,php5,phtml,inc").name("File Suffixes").description("List of suffixes of PHP files to analyze.").onQualifiers("BRC", new String[]{"TRK"}).category(PHP_CATEGORY).multiValues(true).subCategory(GENERAL_SUBCATEGORY).build()});
        if (context.getRuntime().getProduct() != SonarProduct.SONARLINT) {
            context.addExtensions((Object)PropertyDefinition.builder((String)PHPUNIT_TESTS_REPORT_PATH_KEY).name("Unit Test Report").description(String.format(REPORT_PATH_DESCRIPTION_TEMPLATE, "", "unit test execution")).onQualifiers("BRC", new String[]{"TRK"}).category(PHP_CATEGORY).subCategory(PHPUNIT_SUBCATEGORY).build(), (Object)PropertyDefinition.builder((String)PHPUNIT_COVERAGE_REPORT_PATH_KEY).name("Coverage Report").description(String.format(REPORT_PATH_DESCRIPTION_TEMPLATE, DEPRECATION_MESSAGE, "code coverage")).onQualifiers("BRC", new String[]{"TRK"}).category(PHP_CATEGORY).subCategory(PHPUNIT_SUBCATEGORY).build(), new Object[]{PropertyDefinition.builder((String)PHPUNIT_IT_COVERAGE_REPORT_PATH_KEY).name("IT Coverage Report").description(String.format(REPORT_PATH_DESCRIPTION_TEMPLATE, DEPRECATION_MESSAGE, "integration test code coverage")).onQualifiers("BRC", new String[]{"TRK"}).category(PHP_CATEGORY).subCategory(PHPUNIT_SUBCATEGORY).build(), PropertyDefinition.builder((String)PHPUNIT_OVERALL_COVERAGE_REPORT_PATH_KEY).name("Overall Coverage Report").description(String.format(REPORT_PATH_DESCRIPTION_TEMPLATE, DEPRECATION_MESSAGE, "overall code coverage")).onQualifiers("BRC", new String[]{"TRK"}).category(PHP_CATEGORY).subCategory(PHPUNIT_SUBCATEGORY).build()});
        }
        context.addExtension((Object)PropertyDefinition.builder((String)PHPUNIT_COVERAGE_REPORT_PATHS_KEY).name("Coverage Reports").description("List of PHPUnit code coverage report files. Each path can be either absolute or relative.").onQualifiers("BRC", new String[]{"TRK"}).category(PHP_CATEGORY).multiValues(true).subCategory(PHPUNIT_SUBCATEGORY).build());
    }
}

