/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php;

import com.google.common.annotations.VisibleForTesting;
import com.sonar.sslr.api.RecognitionException;
import java.util.List;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.php.checks.CheckList;
import org.sonar.php.compat.CompatibleInputFile;
import org.sonar.php.ini.PhpIniCheck;
import org.sonar.php.ini.PhpIniIssue;
import org.sonar.php.ini.PhpIniParser;
import org.sonar.php.ini.tree.PhpIniFile;

public class PhpIniSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(PhpIniSensor.class);
    private final CheckFactory checkFactory;

    public PhpIniSensor(CheckFactory checkFactory) {
        this.checkFactory = checkFactory;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("Analyzer for \"php.ini\" files").onlyOnLanguage("php");
    }

    public void execute(SensorContext context) {
        Checks checks = this.checkFactory.create("php").addAnnotatedChecks(CheckList.getPhpIniChecks());
        this.execute(context, (Checks<PhpIniCheck>)checks);
    }

    @VisibleForTesting
    protected void execute(SensorContext context, Checks<PhpIniCheck> checks) {
        PhpIniParser parser = new PhpIniParser();
        FileSystem fs = context.fileSystem();
        Iterable inputFiles = fs.inputFiles(fs.predicates().matchesPathPattern("**/php.ini"));
        for (InputFile inputFile : inputFiles) {
            PhpIniFile phpIni;
            try {
                phpIni = parser.parse(new CompatibleInputFile(inputFile));
            }
            catch (RecognitionException e) {
                LOG.error("Unable to parse file: " + inputFile.absolutePath());
                LOG.error(e.getMessage());
                continue;
            }
            for (PhpIniCheck check : checks.all()) {
                List<PhpIniIssue> issues = check.analyze(phpIni);
                PhpIniSensor.saveIssues(context, inputFile, checks.ruleKey((Object)check), issues);
            }
        }
    }

    private static void saveIssues(SensorContext context, InputFile inputFile, RuleKey ruleKey, List<PhpIniIssue> issues) {
        for (PhpIniIssue phpIssue : issues) {
            NewIssue issue = context.newIssue();
            NewIssueLocation location = issue.newLocation().message(phpIssue.message()).on((InputComponent)inputFile);
            if (phpIssue.line() > 0) {
                location.at(inputFile.selectLine(phpIssue.line()));
            }
            issue.forRule(ruleKey).at(location).save();
        }
    }
}

