/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.sonar.sslr.api.RecognitionException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.php.PHPAnalyzer;
import org.sonar.php.checks.CheckList;
import org.sonar.php.checks.ParsingErrorCheck;
import org.sonar.php.compat.CompatibleInputFile;
import org.sonar.php.metrics.CpdVisitor;
import org.sonar.php.metrics.FileMeasures;
import org.sonar.php.tree.visitors.LegacyIssue;
import org.sonar.plugins.php.AnalysisException;
import org.sonar.plugins.php.PHPChecks;
import org.sonar.plugins.php.api.visitors.FileIssue;
import org.sonar.plugins.php.api.visitors.IssueLocation;
import org.sonar.plugins.php.api.visitors.LineIssue;
import org.sonar.plugins.php.api.visitors.PHPCustomRuleRepository;
import org.sonar.plugins.php.api.visitors.PHPCustomRulesDefinition;
import org.sonar.plugins.php.api.visitors.PhpIssue;
import org.sonar.plugins.php.api.visitors.PreciseIssue;
import org.sonar.plugins.php.phpunit.CompatibilityImportersFactory;
import org.sonar.plugins.php.phpunit.TestResultImporter;
import org.sonar.squidbridge.ProgressReport;

public class PHPSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(PHPSensor.class);
    private final FileLinesContextFactory fileLinesContextFactory;
    private final PHPChecks checks;
    private final NoSonarFilter noSonarFilter;
    private RuleKey parsingErrorRuleKey;

    public PHPSensor(FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter) {
        this(fileLinesContextFactory, checkFactory, noSonarFilter, null);
    }

    public PHPSensor(FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, @Nullable PHPCustomRuleRepository[] customRuleRepositories) {
        this.checks = PHPChecks.createPHPCheck(checkFactory).addChecks("php", CheckList.getChecks()).addCustomChecks(customRuleRepositories);
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.noSonarFilter = noSonarFilter;
        this.parsingErrorRuleKey = this.getParsingErrorRuleKey();
        PHPCustomRulesDefinition.class.getName();
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("php").name("PHP sensor").onlyOnFileType(InputFile.Type.MAIN);
    }

    public void execute(SensorContext context) {
        FileSystem fileSystem = context.fileSystem();
        FilePredicate mainFilePredicate = fileSystem.predicates().and(fileSystem.predicates().hasType(InputFile.Type.MAIN), fileSystem.predicates().hasLanguage("php"));
        PHPAnalyzer phpAnalyzer = new PHPAnalyzer(ImmutableList.copyOf(this.checks.all()));
        ArrayList<InputFile> inputFiles = new ArrayList<InputFile>();
        fileSystem.inputFiles(mainFilePredicate).forEach(inputFiles::add);
        ProgressReport progressReport = new ProgressReport("Report about progress of PHP analyzer", TimeUnit.SECONDS.toMillis(10L));
        progressReport.start(inputFiles.stream().map(InputFile::toString).collect(Collectors.toList()));
        try {
            this.analyseFiles(context, phpAnalyzer, inputFiles, progressReport);
            if (PHPSensor.inSonarQube(context)) {
                PHPSensor.processTestsAndCoverage(context);
            }
        }
        catch (CancellationException e) {
            LOG.info(e.getMessage());
        }
    }

    private static boolean inSonarQube(SensorContext context) {
        return context.runtime().getProduct() != SonarProduct.SONARLINT;
    }

    private static void processTestsAndCoverage(SensorContext context) {
        new TestResultImporter().importReport(context);
        CompatibilityImportersFactory importersFactory = new CompatibilityImportersFactory(context);
        importersFactory.deprecationWarnings().forEach(arg_0 -> ((Logger)LOG).warn(arg_0));
        importersFactory.createCoverageImporter().importReport(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void analyseFiles(SensorContext context, PHPAnalyzer phpAnalyzer, Iterable<InputFile> inputFiles, ProgressReport progressReport) {
        boolean success = false;
        try {
            for (InputFile inputFile : inputFiles) {
                PHPSensor.checkCancelled(context);
                progressReport.nextFile();
                this.analyseFile(context, phpAnalyzer, inputFile);
            }
            success = true;
        }
        finally {
            PHPSensor.stopProgressReport(progressReport, success);
        }
    }

    private static void checkCancelled(SensorContext context) {
        if (context.isCancelled()) {
            throw new CancellationException("Analysis cancelled");
        }
    }

    private static void stopProgressReport(ProgressReport progressReport, boolean success) {
        if (success) {
            progressReport.stop();
        } else {
            progressReport.cancel();
        }
    }

    private void analyseFile(SensorContext context, PHPAnalyzer phpAnalyzer, InputFile inputFile) {
        try {
            phpAnalyzer.nextFile(new CompatibleInputFile(inputFile));
            if (PHPSensor.inSonarQube(context)) {
                phpAnalyzer.getSyntaxHighlighting(context, inputFile).save();
                phpAnalyzer.getSymbolHighlighting(context, inputFile).save();
                PHPSensor.saveNewFileMeasures(context, phpAnalyzer.computeMeasures(this.fileLinesContextFactory.createFor(inputFile)), inputFile);
                if (PHPSensor.inSonarQube(context)) {
                    PHPSensor.saveCpdData(phpAnalyzer.computeCpdTokens(), inputFile, context);
                }
            }
            this.noSonarFilter.noSonarInFile(inputFile, phpAnalyzer.computeNoSonarLines());
            this.saveIssues(context, phpAnalyzer.analyze(), inputFile);
        }
        catch (RecognitionException e) {
            PHPSensor.checkInterrupted(e);
            LOG.error("Unable to parse file: " + inputFile.filename());
            LOG.error(e.getMessage());
            this.saveParsingIssue(context, e, inputFile);
            return;
        }
        catch (Exception e) {
            PHPSensor.checkInterrupted(e);
            throw new AnalysisException("Could not analyse " + inputFile.filename(), e);
        }
    }

    private static void checkInterrupted(Exception e) {
        Throwable cause = Throwables.getRootCause(e);
        if (cause instanceof InterruptedException || cause instanceof InterruptedIOException) {
            throw new AnalysisException("Analysis cancelled", e);
        }
    }

    private static void saveNewFileMeasures(SensorContext context, FileMeasures fileMeasures, InputFile inputFile) {
        context.newMeasure().on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMeasures.getLinesOfCodeNumber())).forMetric((Metric)CoreMetrics.NCLOC).save();
        context.newMeasure().on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMeasures.getCommentLinesNumber())).forMetric((Metric)CoreMetrics.COMMENT_LINES).save();
        context.newMeasure().on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMeasures.getClassNumber())).forMetric((Metric)CoreMetrics.CLASSES).save();
        context.newMeasure().on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMeasures.getFunctionNumber())).forMetric((Metric)CoreMetrics.FUNCTIONS).save();
        context.newMeasure().on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMeasures.getStatementNumber())).forMetric((Metric)CoreMetrics.STATEMENTS).save();
        context.newMeasure().on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMeasures.getFileCognitiveComplexity())).forMetric((Metric)CoreMetrics.COGNITIVE_COMPLEXITY).save();
        context.newMeasure().on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMeasures.getFileComplexity())).forMetric((Metric)CoreMetrics.COMPLEXITY).save();
        context.newMeasure().on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMeasures.getClassComplexity())).forMetric((Metric)CoreMetrics.COMPLEXITY_IN_CLASSES).save();
        context.newMeasure().on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMeasures.getFunctionComplexity())).forMetric((Metric)CoreMetrics.COMPLEXITY_IN_FUNCTIONS).save();
        String functionComplexityMeasure = fileMeasures.getFunctionComplexityDistribution().build();
        context.newMeasure().on((InputComponent)inputFile).withValue((Serializable)((Object)functionComplexityMeasure)).forMetric((Metric)CoreMetrics.FUNCTION_COMPLEXITY_DISTRIBUTION).save();
        String fileComplexityMeasure = fileMeasures.getFileComplexityDistribution().build();
        context.newMeasure().on((InputComponent)inputFile).withValue((Serializable)((Object)fileComplexityMeasure)).forMetric((Metric)CoreMetrics.FILE_COMPLEXITY_DISTRIBUTION).save();
    }

    private void saveParsingIssue(SensorContext context, RecognitionException e, InputFile inputFile) {
        if (this.parsingErrorRuleKey != null) {
            NewIssue issue = context.newIssue();
            NewIssueLocation location = issue.newLocation().message(e.getMessage()).on((InputComponent)inputFile).at(inputFile.selectLine(e.getLine()));
            issue.forRule(this.parsingErrorRuleKey).at(location).save();
        }
        context.newAnalysisError().onFile(inputFile).at(inputFile.newPointer(e.getLine(), 0)).message(e.getMessage()).save();
    }

    private void saveIssues(SensorContext context, List<PhpIssue> issues, InputFile inputFile) {
        for (PhpIssue issue : issues) {
            NewIssueLocation location;
            RuleKey ruleKey = this.checks.ruleKeyFor(issue.check());
            NewIssue newIssue = context.newIssue().forRule(ruleKey).gap(issue.cost());
            if (issue instanceof LegacyIssue) {
                LegacyIssue legacyIssue = (LegacyIssue)issue;
                location = newIssue.newLocation().message(legacyIssue.message()).on((InputComponent)inputFile);
                if (legacyIssue.line() > 0) {
                    location.at(inputFile.selectLine(legacyIssue.line()));
                }
                newIssue.at(location);
            } else if (issue instanceof LineIssue) {
                LineIssue lineIssue = (LineIssue)issue;
                location = newIssue.newLocation().message(lineIssue.message()).on((InputComponent)inputFile).at(inputFile.selectLine(lineIssue.line()));
                newIssue.at(location);
            } else if (issue instanceof FileIssue) {
                FileIssue fileIssue = (FileIssue)issue;
                location = newIssue.newLocation().message(fileIssue.message()).on((InputComponent)inputFile);
                newIssue.at(location);
            } else {
                PreciseIssue preciseIssue = (PreciseIssue)issue;
                newIssue.at(PHPSensor.newLocation(inputFile, newIssue, preciseIssue.primaryLocation()));
                preciseIssue.secondaryLocations().forEach(secondary -> newIssue.addLocation(PHPSensor.newLocation(inputFile, newIssue, secondary)));
            }
            newIssue.save();
        }
    }

    private static NewIssueLocation newLocation(InputFile inputFile, NewIssue issue, IssueLocation location) {
        TextRange range = inputFile.newRange(location.startLine(), location.startLineOffset(), location.endLine(), location.endLineOffset());
        NewIssueLocation newLocation = issue.newLocation().on((InputComponent)inputFile).at(range);
        if (location.message() != null) {
            newLocation.message(location.message());
        }
        return newLocation;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private RuleKey getParsingErrorRuleKey() {
        List keys = this.checks.all().stream().filter(check -> check instanceof ParsingErrorCheck).map(this.checks::ruleKeyFor).collect(Collectors.toList());
        return keys.isEmpty() ? null : (RuleKey)keys.get(0);
    }

    private static void saveCpdData(List<CpdVisitor.CpdToken> cpdTokens, InputFile inputFile, SensorContext context) {
        NewCpdTokens newCpdTokens = context.newCpdTokens().onFile(inputFile);
        cpdTokens.forEach(cpdToken -> newCpdTokens.addToken(inputFile.newRange(cpdToken.syntaxToken().line(), cpdToken.syntaxToken().column(), cpdToken.syntaxToken().endLine(), cpdToken.syntaxToken().endColumn()), cpdToken.image()));
        newCpdTokens.save();
    }

    private static class CancellationException
    extends RuntimeException {
        CancellationException(String message) {
            super(message);
        }
    }
}

