/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.utils;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;

public class SourceBuilder
extends PHPSubscriptionCheck {
    private final StringBuilder stringBuilder = new StringBuilder();
    private int line = 1;
    private int column = 0;

    public static String build(Tree tree) {
        SourceBuilder writer = new SourceBuilder();
        writer.scanTree(tree);
        return writer.stringBuilder.toString();
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of(Tree.Kind.TOKEN, Tree.Kind.INLINE_HTML_TOKEN);
    }

    @Override
    public void visitNode(Tree tree) {
        SyntaxToken token = (SyntaxToken)tree;
        for (SyntaxTrivia trivia : token.trivias()) {
            this.appendToken(trivia);
        }
        this.appendToken(token);
    }

    private void appendToken(SyntaxToken token) {
        this.insertMissingSpaceBefore(token.line(), token.column());
        String text = token.text();
        this.stringBuilder.append(text);
        String[] lines = text.split("\r\n|\n|\r", -1);
        if (lines.length > 1) {
            this.line += lines.length - 1;
            this.column = lines[lines.length - 1].length();
        } else {
            this.column += text.length();
        }
    }

    private void insertMissingSpaceBefore(int tokenLine, int tokenColumn) {
        int linesToInsert = tokenLine - this.line;
        if (linesToInsert < 0) {
            throw new IllegalStateException("Illegal token line for " + tokenLine);
        }
        if (linesToInsert > 0) {
            for (int i = 0; i < linesToInsert; ++i) {
                this.stringBuilder.append("\n");
                ++this.line;
            }
            this.column = 0;
        }
        int spacesToInsert = tokenColumn - this.column;
        for (int i = 0; i < spacesToInsert; ++i) {
            this.stringBuilder.append(' ');
            ++this.column;
        }
    }
}

