/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.visitors;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.sonar.php.tree.symbols.SymbolTableImpl;
import org.sonar.php.tree.visitors.LegacyIssue;
import org.sonar.plugins.php.api.symbols.SymbolTable;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.visitors.CheckContext;
import org.sonar.plugins.php.api.visitors.FileIssue;
import org.sonar.plugins.php.api.visitors.IssueLocation;
import org.sonar.plugins.php.api.visitors.LineIssue;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PhpFile;
import org.sonar.plugins.php.api.visitors.PhpIssue;
import org.sonar.plugins.php.api.visitors.PreciseIssue;

public class PHPCheckContext
implements CheckContext {
    private final PhpFile file;
    private final CompilationUnitTree tree;
    private final SymbolTable symbolTable;
    private List<PhpIssue> issues;

    public PHPCheckContext(PhpFile file, CompilationUnitTree tree) {
        this(file, tree, SymbolTableImpl.create(tree));
    }

    public PHPCheckContext(PhpFile file, CompilationUnitTree tree, SymbolTable symbolTable) {
        this.file = file;
        this.tree = tree;
        this.symbolTable = symbolTable;
        this.issues = new ArrayList<PhpIssue>();
    }

    @Override
    public CompilationUnitTree tree() {
        return this.tree;
    }

    @Override
    public LegacyIssue newIssue(PHPCheck check, String message) {
        LegacyIssue issue = new LegacyIssue(check, message);
        this.issues.add(issue);
        return issue;
    }

    @Override
    public PreciseIssue newIssue(PHPCheck check, Tree tree, String message) {
        PreciseIssue issue = new PreciseIssue(check, new IssueLocation(tree, message));
        this.issues.add(issue);
        return issue;
    }

    @Override
    public PreciseIssue newIssue(PHPCheck check, Tree startTree, Tree endTree, String message) {
        PreciseIssue issue = new PreciseIssue(check, new IssueLocation(startTree, endTree, message));
        this.issues.add(issue);
        return issue;
    }

    @Override
    public LineIssue newLineIssue(PHPCheck check, int line, String message) {
        LineIssue issue = new LineIssue(check, line, message);
        this.issues.add(issue);
        return issue;
    }

    @Override
    public FileIssue newFileIssue(PHPCheck check, String message) {
        FileIssue issue = new FileIssue(check, message);
        this.issues.add(issue);
        return issue;
    }

    @Override
    public File file() {
        return this.file.file();
    }

    @Override
    public PhpFile getPhpFile() {
        return this.file;
    }

    public ImmutableList<PhpIssue> getIssues() {
        return ImmutableList.copyOf(this.issues);
    }

    @Override
    public SymbolTable symbolTable() {
        return this.symbolTable;
    }
}

