/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.symbols;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.sonar.php.api.PHPKeyword;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.symbols.Scope;
import org.sonar.php.tree.symbols.SymbolTableImpl;
import org.sonar.php.utils.SourceBuilder;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.SeparatedList;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassMemberTree;
import org.sonar.plugins.php.api.tree.declaration.ClassPropertyDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassTree;
import org.sonar.plugins.php.api.tree.declaration.ConstantDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.declaration.ParameterTree;
import org.sonar.plugins.php.api.tree.declaration.VariableDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.tree.expression.CompoundVariableTree;
import org.sonar.plugins.php.api.tree.expression.ComputedVariableTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.php.api.tree.expression.IdentifierTree;
import org.sonar.plugins.php.api.tree.expression.LexicalVariablesTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.expression.MemberAccessTree;
import org.sonar.plugins.php.api.tree.expression.NameIdentifierTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.tree.expression.VariableTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.GlobalStatementTree;
import org.sonar.plugins.php.api.tree.statement.StaticStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

public class SymbolVisitor
extends PHPVisitorCheck {
    private static final Set<String> BUILT_IN_VARIABLES = ImmutableSet.of("$THIS", "$GLOBALS", "$_SERVER", "$_GET", "$_POST", "$_FILES", new String[]{"$_SESSION", "$_ENV", "$PHP_ERRORMSG", "$HTTP_RAW_POST_DATA", "$HTTP_RESPONSE_HEADER", "$ARGC", "$ARGV", "$_COOKIE", "$_REQUEST"});
    private Scope classScope = null;
    private Map<Symbol, Scope> scopeBySymbol = new HashMap<Symbol, Scope>();
    private static final ImmutableSet<String> SELF_OBJECTS = ImmutableSet.of("$this", "self", "static");
    private SymbolTableImpl symbolTable;
    private Scope currentScope;
    private Scope globalScope;
    private ClassMemberUsageState classMemberUsageState = null;

    public SymbolVisitor(SymbolTableImpl symbolTable) {
        this.symbolTable = symbolTable;
        this.currentScope = null;
        this.globalScope = null;
    }

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.enterScope(tree);
        this.globalScope = this.currentScope;
        super.visitCompilationUnit(tree);
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.createSymbol(tree.name(), Symbol.Kind.FUNCTION);
        this.enterScope(tree);
        super.visitFunctionDeclaration(tree);
        this.leaveScope();
    }

    @Override
    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.enterScope(tree);
        super.visitFunctionExpression(tree);
        this.leaveScope();
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.enterScope(tree);
        super.visitMethodDeclaration(tree);
        this.leaveScope();
    }

    @Override
    public void visitClassPropertyDeclaration(ClassPropertyDeclarationTree tree) {
    }

    @Override
    public void visitClassDeclaration(ClassDeclarationTree tree) {
        Symbol classSymbol = this.createSymbol(tree.name(), Symbol.Kind.CLASS);
        this.enterScope(tree);
        this.classScope = this.currentScope;
        this.scan(tree.name());
        NamespaceNameTree superClass = tree.superClass();
        if (superClass != null) {
            this.scan(superClass.namespaces());
            Symbol superClassSymbol = this.resolveSymbol(superClass.name());
            this.classScope.superClassScope = this.scopeBySymbol.get(superClassSymbol);
        }
        this.scopeBySymbol.put(classSymbol, this.classScope);
        this.scan(tree.superInterfaces());
        this.createMemberSymbols(tree);
        this.scan(tree.members());
        this.classScope = null;
        this.leaveScope();
    }

    @Override
    public void visitAnonymousClass(AnonymousClassTree tree) {
        this.enterScope(tree);
        this.classScope = this.currentScope;
        this.createMemberSymbols(tree);
        super.visitAnonymousClass(tree);
        this.classScope = null;
        this.leaveScope();
    }

    private void createMemberSymbols(ClassTree tree) {
        for (ClassMemberTree member : tree.members()) {
            if (member.is(Tree.Kind.METHOD_DECLARATION)) {
                this.createSymbol(((MethodDeclarationTree)member).name(), Symbol.Kind.FUNCTION).addModifiers(((MethodDeclarationTree)member).modifiers());
                continue;
            }
            if (!member.is(Tree.Kind.CLASS_CONSTANT_PROPERTY_DECLARATION, Tree.Kind.CLASS_PROPERTY_DECLARATION)) continue;
            ClassPropertyDeclarationTree classPropertyDeclaration = (ClassPropertyDeclarationTree)member;
            for (VariableDeclarationTree field : classPropertyDeclaration.declarations()) {
                this.createSymbol(field.identifier(), Symbol.Kind.FIELD).addModifiers(classPropertyDeclaration.modifierTokens());
                ExpressionTree initValue = field.initValue();
                if (initValue == null) continue;
                initValue.accept(this);
            }
        }
    }

    @Override
    public void visitConstDeclaration(ConstantDeclarationTree tree) {
        for (VariableDeclarationTree constant : tree.declarations()) {
            this.createSymbol(constant.identifier(), Symbol.Kind.VARIABLE).addModifiers(Lists.newArrayList(tree.constToken()));
        }
    }

    @Override
    public void visitVariableIdentifier(VariableIdentifierTree tree) {
        if (!SymbolVisitor.isBuiltInVariable(tree)) {
            if (this.classMemberUsageState == null) {
                this.createOrUseVariableIdentifierSymbol(tree);
            } else {
                Symbol symbol;
                if (this.classMemberUsageState.isSelfMember && this.classScope != null && this.classMemberUsageState.isStatic && (symbol = this.classScope.getSymbol(tree.text(), Symbol.Kind.FIELD)) != null) {
                    this.associateSymbol(tree, symbol);
                }
                if ((symbol = this.currentScope.getSymbol(tree.text(), Symbol.Kind.VARIABLE, Symbol.Kind.PARAMETER)) != null) {
                    this.associateSymbol(tree, symbol);
                }
                this.classMemberUsageState = null;
            }
        }
    }

    private void createOrUseVariableIdentifierSymbol(VariableIdentifierTree identifier) {
        Symbol symbol = this.currentScope.getSymbol(identifier.text(), Symbol.Kind.PARAMETER);
        if (symbol == null) {
            this.createSymbol(identifier, Symbol.Kind.VARIABLE);
            return;
        }
        this.associateSymbol(identifier, symbol);
    }

    @Override
    public void visitToken(SyntaxToken token) {
        if (this.classMemberUsageState != null && this.classMemberUsageState.isStatic && token.text().equals(PHPKeyword.CLASS.getValue())) {
            this.classMemberUsageState = null;
        }
        super.visitToken(token);
    }

    @Override
    public void visitNameIdentifier(NameIdentifierTree tree) {
        if (this.classMemberUsageState != null && this.classScope != null) {
            this.resolveProperty(tree);
        } else {
            this.resolveSymbol(tree);
        }
        this.classMemberUsageState = null;
    }

    private Symbol resolveSymbol(IdentifierTree tree) {
        Symbol symbol = null;
        for (Scope outer = this.currentScope; outer != null; outer = outer.outer()) {
            symbol = outer.getSymbol(tree.text(), Symbol.Kind.CLASS);
            if (symbol == null) continue;
            this.associateSymbol(tree, symbol);
            break;
        }
        return symbol;
    }

    private void resolveProperty(NameIdentifierTree tree) {
        Symbol symbol;
        String name = tree.text();
        Symbol.Kind kind = Symbol.Kind.FUNCTION;
        if (this.classMemberUsageState.isField) {
            name = (this.classMemberUsageState.isConst ? "" : "$") + name;
            kind = Symbol.Kind.FIELD;
        }
        if ((symbol = this.classScope.getSymbol(name, kind)) != null) {
            this.associateSymbol(tree, symbol);
        }
    }

    private static boolean isBuiltInVariable(VariableIdentifierTree tree) {
        return BUILT_IN_VARIABLES.contains(tree.text().toUpperCase(Locale.ENGLISH));
    }

    @Override
    public void visitCompoundVariable(CompoundVariableTree tree) {
        Symbol symbol;
        SyntaxToken firstExpressionToken = ((PHPTree)((Object)tree.variableExpression())).getFirstToken();
        if (firstExpressionToken.text().charAt(0) != '$' && (symbol = this.currentScope.getSymbol("$" + firstExpressionToken.text(), new Symbol.Kind[0])) != null) {
            this.associateSymbol(firstExpressionToken, symbol);
        }
        super.visitCompoundVariable(tree);
    }

    @Override
    public void visitParameter(ParameterTree tree) {
        this.createSymbol(tree.variableIdentifier(), Symbol.Kind.PARAMETER);
        ExpressionTree initValue = tree.initValue();
        if (initValue != null) {
            initValue.accept(this);
        }
    }

    @Override
    public void visitGlobalStatement(GlobalStatementTree tree) {
        for (VariableTree variable : tree.variables()) {
            if (!variable.is(Tree.Kind.VARIABLE_IDENTIFIER)) continue;
            IdentifierTree identifier = (IdentifierTree)variable.variableExpression();
            Symbol symbol = this.globalScope.getSymbol(identifier.text(), Symbol.Kind.VARIABLE);
            if (symbol != null) {
                this.associateSymbol(identifier, symbol);
                this.currentScope.addSymbol(symbol);
            } else {
                symbol = this.createSymbol(identifier, Symbol.Kind.VARIABLE);
            }
            symbol.addModifiers(Collections.singletonList(tree.globalToken()));
        }
    }

    @Override
    public void visitStaticStatement(StaticStatementTree tree) {
        super.visitStaticStatement(tree);
        for (VariableDeclarationTree variable : tree.variables()) {
            Symbol symbol = this.currentScope.getSymbol(variable.identifier().text(), Symbol.Kind.VARIABLE);
            if (symbol == null) continue;
            symbol.addModifiers(Collections.singletonList(tree.staticToken()));
        }
    }

    @Override
    public void visitLexicalVariables(LexicalVariablesTree tree) {
        for (VariableTree variable : tree.variables()) {
            IdentifierTree identifier = null;
            if (variable.is(Tree.Kind.VARIABLE_IDENTIFIER)) {
                identifier = (IdentifierTree)variable.variableExpression();
            } else if (variable.is(Tree.Kind.REFERENCE_VARIABLE) && variable.variableExpression().is(Tree.Kind.VARIABLE_IDENTIFIER)) {
                identifier = ((VariableIdentifierTree)variable.variableExpression()).variableExpression();
            }
            if (identifier == null) continue;
            Symbol symbol = this.currentScope.outer().getSymbol(identifier.text(), new Symbol.Kind[0]);
            if (symbol != null) {
                this.associateSymbol(identifier, symbol);
            } else if (variable.is(Tree.Kind.REFERENCE_VARIABLE)) {
                this.symbolTable.declareSymbol(identifier, Symbol.Kind.VARIABLE, this.currentScope.outer());
            }
            this.createSymbol(identifier, Symbol.Kind.VARIABLE);
        }
    }

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        if (tree.callee().is(Tree.Kind.NAMESPACE_NAME)) {
            NamespaceNameTree namespaceNameCallee = (NamespaceNameTree)tree.callee();
            this.usageForNamespaceName(namespaceNameCallee, Symbol.Kind.FUNCTION);
        }
        tree.callee().accept(this);
        String callee = SourceBuilder.build(tree.callee()).trim();
        if ("compact".equals(callee)) {
            this.visitCompactFunctionCall(tree.arguments());
        }
        this.scan(tree.arguments());
    }

    private void visitCompactFunctionCall(SeparatedList<ExpressionTree> arguments) {
        for (ExpressionTree argument : arguments) {
            if (!argument.is(Tree.Kind.REGULAR_STRING_LITERAL)) continue;
            String value = ((LiteralTree)argument).value();
            String variableName = "$" + value.substring(1, value.length() - 1);
            Symbol symbol = this.currentScope.getSymbol(variableName, Symbol.Kind.VARIABLE, Symbol.Kind.PARAMETER);
            if (symbol == null) continue;
            this.associateSymbol(((LiteralTree)argument).token(), symbol);
        }
    }

    private void usageForNamespaceName(NamespaceNameTree namespaceName, Symbol.Kind kind) {
        NameIdentifierTree usageIdentifier;
        Symbol symbol;
        if (namespaceName.name().is(Tree.Kind.NAME_IDENTIFIER) && namespaceName.namespaces().isEmpty() && (symbol = this.currentScope.getSymbol((usageIdentifier = (NameIdentifierTree)namespaceName.name()).text(), kind)) != null) {
            this.associateSymbol(usageIdentifier, symbol);
        }
    }

    @Override
    public void visitMemberAccess(MemberAccessTree tree) {
        boolean functionCall = tree.getParent().is(Tree.Kind.FUNCTION_CALL) && ((FunctionCallTree)tree.getParent()).callee() == tree;
        tree.object().accept(this);
        this.classMemberUsageState = new ClassMemberUsageState();
        this.classMemberUsageState.isStatic = tree.isStatic();
        this.classMemberUsageState.isSelfMember = SymbolVisitor.isSelfMember(tree);
        this.classMemberUsageState.isField = !functionCall;
        this.classMemberUsageState.isConst = this.classMemberUsageState.isField && tree.isStatic();
        tree.member().accept(this);
    }

    private static boolean isSelfMember(MemberAccessTree tree) {
        String strObject = SourceBuilder.build(tree.object()).trim();
        return SELF_OBJECTS.contains(strObject.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public void visitComputedVariable(ComputedVariableTree tree) {
        this.classMemberUsageState = null;
        super.visitComputedVariable(tree);
    }

    private void leaveScope() {
        Preconditions.checkState(this.currentScope != null, "Current scope should never be null when calling method \"leaveScope\"");
        this.currentScope = this.currentScope.outer();
    }

    private void enterScope(Tree tree) {
        this.currentScope = new Scope(this.currentScope, tree);
        this.symbolTable.addScope(this.currentScope);
    }

    private Symbol createSymbol(IdentifierTree identifier, Symbol.Kind kind) {
        Symbol symbol = this.currentScope.getSymbol(identifier.text(), kind);
        if (symbol == null) {
            symbol = this.symbolTable.declareSymbol(identifier, kind, this.currentScope);
            this.symbolTable.associateSymbol(identifier, symbol);
        } else {
            this.associateSymbol(identifier, symbol);
        }
        return symbol;
    }

    private void associateSymbol(IdentifierTree tree, Symbol symbol) {
        symbol.addUsage(tree);
        this.symbolTable.associateSymbol(tree, symbol);
    }

    private void associateSymbol(SyntaxToken token, Symbol symbol) {
        symbol.addUsage(token);
        this.symbolTable.associateSymbol(token, symbol);
    }

    static class ClassMemberUsageState {
        boolean isStatic = false;
        boolean isField = false;
        boolean isSelfMember = false;
        boolean isConst = false;

        ClassMemberUsageState() {
        }
    }
}

